/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.focus.DockableSelectionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class AbstractDockableSelection
extends JPanel
implements DockableSelection {
    private List<DockableSelectionListener> listeners = new ArrayList<DockableSelectionListener>();
    protected final Action UP = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.up();
        }
    };
    protected final Action DOWN = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.down();
        }
    };
    protected final Action LEFT = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.left();
        }
    };
    protected final Action RIGHT = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.right();
        }
    };
    protected final Action CANCEL = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.cancel();
        }
    };
    protected final Action SELECT = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AbstractDockableSelection.this.select();
        }
    };
    private DockController controller;
    private Dockable selection;
    private List<Dockable> dockables = new LinkedList<Dockable>();
    private DockableListener dockableListener = new DockableAdapter(){

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            int index = AbstractDockableSelection.this.dockables.indexOf(dockable);
            AbstractDockableSelection.this.titleChanged(index, dockable);
        }

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            int index = AbstractDockableSelection.this.dockables.indexOf(dockable);
            AbstractDockableSelection.this.iconChanged(index, dockable);
        }
    };
    private DockRegisterListener registerListener = new DockAdapter(){

        public void dockableRegistered(DockController controller, Dockable dockable) {
            if (AbstractDockableSelection.this.selectable(dockable)) {
                AbstractDockableSelection.this.add(dockable);
            }
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            AbstractDockableSelection.this.remove(dockable);
        }
    };

    public AbstractDockableSelection() {
        this.setFocusable(true);
        InputMap input = this.getInputMap(1);
        input.put(KeyStroke.getKeyStroke(38, 0), "up");
        input.put(KeyStroke.getKeyStroke(40, 0), "down");
        input.put(KeyStroke.getKeyStroke(37, 0), "left");
        input.put(KeyStroke.getKeyStroke(39, 0), "right");
        input.put(KeyStroke.getKeyStroke(224, 0), "up");
        input.put(KeyStroke.getKeyStroke(225, 0), "down");
        input.put(KeyStroke.getKeyStroke(226, 0), "left");
        input.put(KeyStroke.getKeyStroke(227, 0), "right");
        input.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        input.put(KeyStroke.getKeyStroke(8, 0), "cancel");
        input.put(KeyStroke.getKeyStroke(10, 0), "select");
        input.put(KeyStroke.getKeyStroke(32, 0), "select");
        ActionMap action = this.getActionMap();
        action.put("up", this.UP);
        action.put("down", this.DOWN);
        action.put("left", this.LEFT);
        action.put("right", this.RIGHT);
        action.put("cancel", this.CANCEL);
        action.put("select", this.SELECT);
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasChoices(DockController controller) {
        DockRegister register = controller.getRegister();
        int count = 0;
        int n = register.getDockableCount();
        for (int i = 0; i < n; ++i) {
            if (!this.selectable(register.getDockable(i)) || ++count < 2) continue;
            return true;
        }
        return false;
    }

    public Component getComponent() {
        return this;
    }

    public void open(DockController controller) {
        if (this.controller != null) {
            throw new IllegalStateException("selection already open");
        }
        DockRegister register = controller.getRegister();
        int n = register.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = register.getDockable(i);
            if (!this.selectable(dockable)) continue;
            this.add(dockable);
        }
        this.controller = controller;
        register.addDockRegisterListener(this.registerListener);
        Dockable focus = controller.getFocusedDockable();
        if (focus != null && !this.selectable(focus)) {
            focus = null;
        }
        this.select(focus);
    }

    private void add(Dockable dockable) {
        this.dockables.add(dockable);
        dockable.addDockableListener(this.dockableListener);
        this.insert(this.dockables.size() - 1, dockable);
    }

    public void close() {
        if (this.controller != null) {
            this.controller.getRegister().removeDockRegisterListener(this.registerListener);
            this.controller = null;
        }
        for (int i = this.dockables.size() - 1; i >= 0; --i) {
            Dockable dockable = this.dockables.remove(i);
            dockable.removeDockableListener(this.dockableListener);
            this.remove(i, dockable);
        }
        this.selection = null;
    }

    private void remove(Dockable dockable) {
        int index = this.dockables.indexOf(dockable);
        if (index >= 0) {
            this.dockables.remove(index);
            dockable.removeDockableListener(this.dockableListener);
            this.remove(index, dockable);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    protected boolean selectable(Dockable dockable) {
        return dockable.asDockStation() == null && dockable.getDockParent() != null;
    }

    protected abstract void up();

    protected abstract void down();

    protected abstract void left();

    protected abstract void right();

    protected abstract void insert(int var1, Dockable var2);

    protected abstract void remove(int var1, Dockable var2);

    protected abstract void titleChanged(int var1, Dockable var2);

    protected abstract void iconChanged(int var1, Dockable var2);

    protected abstract void select(Dockable var1);

    protected void setSelection(Dockable dockable) {
        this.selection = dockable;
        for (DockableSelectionListener listener : this.listeners.toArray(new DockableSelectionListener[this.listeners.size()])) {
            listener.considering(dockable);
        }
    }

    protected void cancel() {
        for (DockableSelectionListener listener : this.listeners.toArray(new DockableSelectionListener[this.listeners.size()])) {
            listener.canceled();
        }
    }

    protected void select() {
        if (this.selection != null) {
            Dockable dockable = this.selection;
            for (DockableSelectionListener listener : this.listeners.toArray(new DockableSelectionListener[this.listeners.size()])) {
                listener.selected(dockable);
            }
        }
    }
}

