/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.event.ComponentHierarchyObserverEvent;
import bibliothek.gui.dock.event.ComponentHierarchyObserverListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHierarchyObserver {
    private Set<Component> roots = new HashSet<Component>();
    private Set<Component> components = new HashSet<Component>();
    private Listener listener = new Listener();
    private DockController controller;
    private List<ComponentHierarchyObserverListener> listeners = new ArrayList<ComponentHierarchyObserverListener>();

    public ComponentHierarchyObserver(DockController controller) {
        this.controller = controller;
        controller.addRepresentativeListener(new DockControllerRepresentativeListener(){

            public void representativeAdded(DockController controller, DockElementRepresentative representative) {
                ComponentHierarchyObserver.this.add(representative.getComponent());
            }

            public void representativeRemoved(DockController controller, DockElementRepresentative representative) {
                ComponentHierarchyObserver.this.remove(representative.getComponent());
            }
        });
    }

    public Set<Component> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    public DockController getController() {
        return this.controller;
    }

    public void addListener(ComponentHierarchyObserverListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ComponentHierarchyObserverListener listener) {
        this.listeners.remove(listener);
    }

    protected ComponentHierarchyObserverListener[] listeners() {
        return this.listeners.toArray(new ComponentHierarchyObserverListener[this.listeners.size()]);
    }

    public void add(Component component) {
        this.roots.add(component);
        this.add(component, null);
    }

    private void add(Component component, List<Component> list) {
        boolean fire;
        boolean bl = fire = list == null;
        if (fire) {
            list = new LinkedList<Component>();
        }
        if (this.components.add(component)) {
            list.add(component);
            if (component instanceof Container) {
                Container container = (Container)component;
                container.addContainerListener(this.listener);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    this.add(container.getComponent(i), list);
                }
            }
        }
        if (fire && !list.isEmpty()) {
            list = Collections.unmodifiableList(list);
            ComponentHierarchyObserverEvent event = new ComponentHierarchyObserverEvent(this.controller, list);
            for (ComponentHierarchyObserverListener listener : this.listeners()) {
                listener.added(event);
            }
        }
    }

    public void remove(Component component) {
        this.roots.remove(component);
        this.remove(component, null);
    }

    private void remove(Component component, List<Component> list) {
        if (!this.roots.contains(component)) {
            boolean fire;
            boolean bl = fire = list == null;
            if (fire) {
                list = new LinkedList<Component>();
            }
            if (this.components.remove(component)) {
                list.add(component);
                if (component instanceof Container) {
                    Container container = (Container)component;
                    container.removeContainerListener(this.listener);
                    int n = container.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        this.remove(container.getComponent(i), list);
                    }
                }
            }
            if (fire && !list.isEmpty()) {
                list = Collections.unmodifiableList(list);
                ComponentHierarchyObserverEvent event = new ComponentHierarchyObserverEvent(this.controller, list);
                for (ComponentHierarchyObserverListener listener : this.listeners()) {
                    listener.removed(event);
                }
            }
        }
    }

    private class Listener
    implements ContainerListener {
        private Listener() {
        }

        public void componentAdded(ContainerEvent e) {
            ComponentHierarchyObserver.this.add(e.getChild(), null);
        }

        public void componentRemoved(ContainerEvent e) {
            ComponentHierarchyObserver.this.remove(e.getChild(), null);
        }
    }
}

