/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.draw;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.odfdom.type.AnyURI;
import org.odftoolkit.odfdom.type.Length;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfDrawImage
extends DrawImageElement {
    private URI mImageURI;
    private OdfPackage mOdfPackage;
    private static final String SLASH = "/";

    public OdfDrawImage(OdfFileDom ownerDoc) {
        super(ownerDoc);
        this.mOdfPackage = ownerDoc.getOdfDocument().getPackage();
    }

    public URI getImageUri() {
        try {
            if (this.mImageURI == null) {
                this.mImageURI = new URI(AnyURI.encodePath(this.getXlinkHrefAttribute().toString()));
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfDrawImage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.mImageURI;
    }

    public void setImagePath(String packagePath) {
        try {
            packagePath = packagePath.replaceFirst(this.mOdfDocument.getDocumentPackagePath(), "");
            URI uri = new URI(AnyURI.encodePath(packagePath).toString());
            this.setXlinkHrefAttribute(AnyURI.decodePath(uri.toString()));
            this.mImageURI = uri;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(OdfDrawImage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getPackagePath(String imageRef) {
        if (imageRef.contains(SLASH)) {
            imageRef = imageRef.substring(imageRef.lastIndexOf(SLASH) + 1, imageRef.length());
        }
        String packagePath = OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH + imageRef;
        packagePath = this.mOdfDocument.getDocumentPackagePath() + packagePath;
        return packagePath;
    }

    private void configureInsertedImage(String packagePath) throws Exception {
        this.setImagePath(packagePath);
        this.setXlinkTypeAttribute("simple");
        InputStream is = this.mOdfPackage.getInputStream(packagePath);
        OdfDrawFrame odfFrame = (OdfDrawFrame)((Object)this.getParentNode());
        if (odfFrame != null) {
            BufferedImage image = ImageIO.read(is);
            int height = image.getHeight(null);
            int width = image.getWidth(null);
            odfFrame.setSvgHeightAttribute(Length.mapToUnit(String.valueOf(height) + "px", Length.Unit.CENTIMETER));
            odfFrame.setSvgWidthAttribute(Length.mapToUnit(String.valueOf(width) + "px", Length.Unit.CENTIMETER));
        }
    }

    public String newImage(URI imageUri) throws Exception {
        String imageRef = null;
        imageRef = !imageUri.isAbsolute() ? System.getProperty("user.dir") + '/' + imageUri.toString() : imageUri.toString();
        String mediaType = OdfFileEntry.getMediaType(imageRef);
        String packagePath = this.getPackagePath(imageRef);
        this.mOdfPackage.insert(imageUri, packagePath, mediaType);
        this.configureInsertedImage(packagePath);
        return packagePath;
    }

    public void newImage(InputStream is, String packagePath, String mediaType) throws Exception {
        this.mOdfPackage.insert(is, packagePath, mediaType);
        this.configureInsertedImage(packagePath);
    }

    public static List<OdfDrawImage> getImageByPath(OdfDocument doc, String imagePath) {
        ArrayList<OdfDrawImage> imageList = new ArrayList<OdfDrawImage>();
        try {
            NodeList imageNodes = doc.getContentDom().getElementsByTagNameNS(OdfNamespaceNames.DRAW.getUri(), "image");
            for (int i = 0; i < imageNodes.getLength(); ++i) {
                OdfDrawImage image = (OdfDrawImage)((Object)imageNodes.item(i));
                if (!image.getXlinkHrefAttribute().equals(imagePath)) continue;
                imageList.add(image);
            }
            if (imageList.size() > 0) {
                return imageList;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        return imageList;
    }

    public static void deleteImageByPath(OdfDocument doc, String imagePath) {
        List<OdfDrawImage> imageList = OdfDrawImage.getImageByPath(doc, imagePath);
        if (imageList != null) {
            for (OdfDrawImage image : imageList) {
                String ref = image.getXlinkHrefAttribute().toString();
                doc.getPackage().remove(ref);
                if (image.getParentNode() instanceof OdfDrawFrame) {
                    OdfDrawFrame frame = (OdfDrawFrame)((Object)image.getParentNode());
                    if (frame.getChildNodes().getLength() == 1) {
                        frame.getParentNode().removeChild((Node)((Object)frame));
                    } else {
                        image.getParentNode().removeChild((Node)((Object)image));
                    }
                } else {
                    image.getParentNode().removeChild((Node)((Object)image));
                }
                if (OdfDrawImage.getImageCount(doc) != 0) continue;
                doc.getPackage().remove(OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH);
            }
        }
    }

    public static void deleteImage(OdfDocument doc, OdfDrawImage image) {
        String ref = image.getXlinkHrefAttribute().toString();
        List<OdfDrawImage> imageList = OdfDrawImage.getImageByPath(doc, ref);
        if (imageList.size() == 1) {
            doc.getPackage().remove(ref);
        }
        if (image.getParentNode() instanceof OdfDrawFrame) {
            OdfDrawFrame frame = (OdfDrawFrame)((Object)image.getParentNode());
            if (frame.getChildNodes().getLength() == 1) {
                frame.getParentNode().removeChild((Node)((Object)frame));
            } else {
                image.getParentNode().removeChild((Node)((Object)image));
            }
        } else {
            image.getParentNode().removeChild((Node)((Object)image));
        }
        if (OdfDrawImage.getImageCount(doc) == 0) {
            doc.getPackage().remove(OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH);
        }
    }

    public static int getImageCount(OdfDocument doc) {
        try {
            NodeList imageNodes = doc.getContentDom().getElementsByTagNameNS(OdfNamespaceNames.DRAW.getUri(), "image");
            return imageNodes.getLength();
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            return 0;
        }
    }

    public static List<OdfDrawImage> getImages(OdfDocument doc) {
        ArrayList<OdfDrawImage> imageList = new ArrayList<OdfDrawImage>();
        try {
            NodeList imageNodes = doc.getContentDom().getElementsByTagNameNS(OdfNamespaceNames.DRAW.getUri(), "image");
            for (int i = 0; i < imageNodes.getLength(); ++i) {
                OdfDrawImage image = (OdfDrawImage)((Object)imageNodes.item(i));
                imageList.add(image);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        return imageList;
    }

    public static Set<String> getImagePathSet(OdfDocument doc) {
        HashSet<String> paths = new HashSet<String>();
        List<OdfDrawImage> imageList = OdfDrawImage.getImages(doc);
        for (OdfDrawImage image : imageList) {
            paths.add(image.getXlinkHrefAttribute().toString());
        }
        return paths;
    }
}

