/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeImage;

public class OdfImageDocument
extends OdfDocument {
    private static String EMPTY_IMAGE_DOCUMENT_PATH = "/OdfImageDocument.odi";
    private static OdfDocument.Resource EMPTY_IMAGE_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_IMAGE_DOCUMENT_PATH);

    public static OdfImageDocument newImageDocument() throws Exception {
        return (OdfImageDocument)OdfDocument.loadTemplate(EMPTY_IMAGE_DOCUMENT_RESOURCE);
    }

    public static OdfImageDocument newImageTemplateDocument() throws Exception {
        OdfImageDocument doc = (OdfImageDocument)OdfDocument.loadTemplate(EMPTY_IMAGE_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.IMAGE_TEMPLATE);
        return doc;
    }

    protected OdfImageDocument() {
    }

    public OdfOfficeImage getContentRoot() throws Exception {
        return super.getContentRoot(OdfOfficeImage.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        IMAGE(OdfDocument.OdfMediaType.IMAGE),
        IMAGE_TEMPLATE(OdfDocument.OdfMediaType.IMAGE_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

