/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockFrontendListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.CExternalizedMode;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMinimizedMode;
import bibliothek.gui.dock.common.mode.CNormalMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.mode.PreviousModeDoubleClickStrategy;
import bibliothek.gui.dock.facile.mode.CLocationModeSettings;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.gui.dock.support.mode.UndoableModeSettings;
import bibliothek.util.Path;
import bibliothek.util.container.Single;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLocationModeManager
extends LocationModeManager<CLocationMode> {
    public static final String ICON_MANAGER_KEY_MINIMIZE = "locationmanager.minimize";
    public static final String ICON_MANAGER_KEY_MAXIMIZE = "locationmanager.maximize";
    public static final String ICON_MANAGER_KEY_NORMALIZE = "locationmanager.normalize";
    public static final String ICON_MANAGER_KEY_EXTERNALIZE = "locationmanager.externalize";
    public static final String ICON_MANAGER_KEY_UNEXTERNALIZE = "locationmanager.unexternalize";
    public static final String ICON_MANAGER_KEY_UNMAXIMIZE_EXTERNALIZED = "locationmanager.unmaximize_externalized";
    private CControlAccess control;
    private CNormalMode normalMode;
    private CMaximizedMode maximizedMode;
    private CMinimizedMode minimizedMode;
    private CExternalizedMode externalizedMode;

    public CLocationModeManager(CControlAccess control) {
        super(control.getOwner().intern().getController());
        this.control = control;
        this.setDoubleClickStrategy(new PreviousModeDoubleClickStrategy(this));
        this.minimizedMode = new CMinimizedMode(control.getOwner());
        this.maximizedMode = new CMaximizedMode(control.getOwner());
        this.normalMode = new CNormalMode(control.getOwner());
        this.externalizedMode = new CExternalizedMode(control.getOwner());
        this.putMode(this.minimizedMode);
        this.putMode(this.externalizedMode);
        this.putMode(this.normalMode);
        this.putMode(this.maximizedMode);
        this.addModeManagerListener(new ModeManagerListener<Location, LocationMode>(){

            @Override
            public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            }

            @Override
            public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
            }

            @Override
            public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            }

            @Override
            public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
                CDockableAccess access = CLocationModeManager.this.control.access(((CommonDockable)dockable).getDockable());
                if (access != null) {
                    ExtendedMode mode = CLocationModeManager.this.getMode(dockable);
                    access.informMode(mode);
                }
            }

            @Override
            public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            }
        });
    }

    public CNormalMode getNormalMode() {
        return this.normalMode;
    }

    public CMaximizedMode getMaximizedMode() {
        return this.maximizedMode;
    }

    public CMinimizedMode getMinimizedMode() {
        return this.minimizedMode;
    }

    public CExternalizedMode getExternalizedMode() {
        return this.externalizedMode;
    }

    @Override
    protected boolean createEntryDuringRead(String key) {
        return this.control.shouldStore(key);
    }

    @Override
    public void remove(Dockable dockable) {
        CDockable cdockable;
        String key;
        if (dockable instanceof CommonDockable && (key = this.control.shouldStore(cdockable = ((CommonDockable)dockable).getDockable())) != null) {
            this.addEmpty(key);
        }
        super.remove(dockable);
    }

    @Override
    protected <B> ModeSettings<Location, B> createModeSettings(ModeSettingsConverter<Location, B> converter) {
        return new CLocationModeSettings<B>(converter);
    }

    @Override
    public void readSettings(ModeSettings<Location, ?> settings) {
        UndoableModeSettings undoable = new UndoableModeSettings(){

            public boolean createTemporaryDuringRead(String key) {
                return CLocationModeManager.this.control.getRegister().isMultiId(key);
            }
        };
        final Runnable temporary = this.readSettings(settings, undoable);
        this.control.getOwner().intern().addListener(new CDockFrontendListener(){

            public void loading(CDockFrontend frontend, CSetting setting) {
            }

            public void loaded(CDockFrontend frontend, CSetting setting) {
                temporary.run();
                frontend.removeListener(this);
            }
        });
    }

    @Override
    public Runnable readSettings(ModeSettings<Location, ?> settings, UndoableModeSettings pending) {
        Runnable result = super.readSettings(settings, pending);
        if (settings instanceof CLocationModeSettings) {
            CLocationModeSettings locationSettings = (CLocationModeSettings)settings;
            locationSettings.rescue(this.getMaximizedMode());
        }
        return result;
    }

    public void setLocation(Dockable dockable, CLocation location) {
        ExtendedMode mode = location.findMode();
        if (mode == null) {
            return;
        }
        CLocationMode newMode = (CLocationMode)this.getMode(mode.getModeIdentifier());
        if (newMode == null) {
            return;
        }
        String root = location.findRoot();
        if (root != null) {
            CStation<?> station;
            if (dockable instanceof CommonDockable && (station = this.control.getOwner().getStation(root)) != null && newMode.respectWorkingAreas((DockStation)station.getStation())) {
                if (station.isWorkingArea()) {
                    ((CommonDockable)dockable).getDockable().setWorkingArea(station);
                } else {
                    ((CommonDockable)dockable).getDockable().setWorkingArea(null);
                }
            }
            this.setProperties(newMode, dockable, new Location(mode.getModeIdentifier(), root, location.findProperty()));
            this.apply(dockable, newMode, true);
        } else {
            this.apply(dockable, newMode, false);
        }
    }

    public void setLocation(Dockable dockable, ExtendedMode mode, CLocation location) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (location != null) {
            String root = location.findRoot();
            if (root == null) {
                throw new IllegalArgumentException("the location is not sufficient to find the root station");
            }
            DockableProperty property = location.findProperty();
            if (property == null) {
                throw new IllegalArgumentException("the location does not carry enough information to find the location of dockable");
            }
            ExtendedMode locationMode = location.findMode();
            if (locationMode == null) {
                throw new IllegalArgumentException("the location does not carry enough information to find the mode of dockable");
            }
            if (!mode.getModeIdentifier().equals((Object)locationMode.getModeIdentifier())) {
                throw new IllegalArgumentException("location and mode do not belong together, they do not have the same identifier");
            }
            this.setProperties(this.getMode(mode.getModeIdentifier()), dockable, new Location(mode.getModeIdentifier(), root, property));
        } else {
            this.setProperties(this.getMode(mode.getModeIdentifier()), dockable, null);
        }
    }

    public CLocation getLocation(Dockable dockable) {
        CLocationMode mode = (CLocationMode)this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        return mode.getCLocation(dockable);
    }

    public CLocation getLocation(Dockable dockable, ExtendedMode mode) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        CLocationMode cmode = (CLocationMode)this.getMode(mode.getModeIdentifier());
        Location location = (Location)this.getProperties(cmode, dockable);
        if (location == null) {
            return null;
        }
        return cmode.getCLocation(dockable, location);
    }

    @Override
    public void ensureValidLocation(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            this.ensureValidLocation(((CommonDockable)dockable).getDockable());
        }
    }

    public void ensureValidLocation(CDockable dockable) {
        if (this.isLayouting()) {
            return;
        }
        ExtendedMode mode = this.getMode(dockable.intern());
        if (mode == ExtendedMode.NORMALIZED) {
            CStation<?> currentArea;
            CStation<?> preferredArea = dockable.getWorkingArea();
            if (preferredArea != (currentArea = this.findFirstParentWorkingArea(dockable.intern()))) {
                if (preferredArea == null) {
                    CLocation defaultLocation = this.getNormalMode().getDefaultLocation();
                    dockable.setLocation(defaultLocation);
                } else {
                    dockable.setLocation(preferredArea.getStationLocation());
                }
            }
            mode = this.getMode(dockable.intern());
        }
        if (!this.isModeAvailable(dockable.intern(), mode)) {
            dockable.setExtendedMode(ExtendedMode.NORMALIZED);
        }
    }

    public boolean ensureBasicModes() {
        if (this.isLayouting()) {
            return false;
        }
        final Single result = new Single((Object)false);
        this.runTransaction(new AffectingRunnable(){

            public void run(AffectedSet set) {
                for (Dockable dockable : CLocationModeManager.this.listDockables()) {
                    CLocationMode current = (CLocationMode)CLocationModeManager.this.getCurrentMode(dockable);
                    if (current == null || current.isBasicMode()) continue;
                    List modes = CLocationModeManager.this.getModeHistory(dockable);
                    CLocationMode next = null;
                    for (int i = modes.size() - 1; i >= 0 && next == null; --i) {
                        CLocationMode mode = (CLocationMode)modes.get(i);
                        if (!mode.isBasicMode() || !CLocationModeManager.this.isModeAvailable(dockable, mode.getExtendedMode())) continue;
                        next = mode;
                    }
                    if (next == null) {
                        next = CLocationModeManager.this.getNormalMode();
                    }
                    result.setA((Object)true);
                    CLocationModeManager.this.apply(dockable, next, set, false);
                }
            }
        });
        return (Boolean)result.getA();
    }

    public void resetWorkingAreaChildren() {
        this.runTransaction(new AffectingRunnable(){

            public void run(AffectedSet set) {
                for (Dockable dockable : CLocationModeManager.this.listDockables()) {
                    if (!(dockable instanceof CommonDockable)) continue;
                    CDockable cdockable = ((CommonDockable)dockable).getDockable();
                    CLocationModeManager.this.resetWorkingArea(cdockable, set);
                }
            }
        });
    }

    private void resetWorkingArea(CDockable dockable, AffectedSet set) {
        if (dockable.getWorkingArea() == null) {
            return;
        }
        DockStation parent = dockable.intern().getDockParent();
        if (parent == null) {
            return;
        }
        CLocationMode current = (CLocationMode)this.getCurrentMode(dockable.intern());
        if (current == null) {
            return;
        }
        if (current.respectWorkingAreas(parent)) {
            return;
        }
        List history = this.getPropertyHistory(dockable.intern());
        CLocationMode next = null;
        for (int i = history.size() - 1; i >= 0 && next == null; --i) {
            CStation<?> station;
            CLocationMode mode;
            Location check = (Location)history.get(i);
            Path path = check.getMode();
            String root = check.getRoot();
            if (path == null || root == null || (mode = (CLocationMode)this.getMode(path)) == null || (station = this.control.getOwner().getStation(root)) == null || !mode.respectWorkingAreas((DockStation)station.getStation()) || !mode.isRepresenting((DockStation)station.getStation()) || !this.isModeAvailable(dockable.intern(), mode.getExtendedMode())) continue;
            next = mode;
        }
        if (next == null) {
            next = this.getNormalMode();
        }
        this.apply((Dockable)dockable.intern(), next, set, false);
    }

    public ExtendedMode childsExtendedMode(DockStation parent) {
        while (parent != null) {
            CLocationMode mode = this.getRepresentingMode(parent);
            if (mode != null) {
                return mode.getExtendedMode();
            }
            Dockable dockable = parent.asDockable();
            if (dockable == null) {
                return null;
            }
            parent = dockable.getDockParent();
        }
        return null;
    }

    private CStation<?> findFirstParentWorkingArea(Dockable dockable) {
        DockStation station = dockable.getDockParent();
        Dockable dockable2 = dockable = station == null ? null : station.asDockable();
        if (dockable != null) {
            return this.getAreaOf(dockable);
        }
        return null;
    }

    protected CStation<?> getAreaOf(Dockable dockable) {
        CStation station;
        HashMap stations = new HashMap();
        for (CStation<?> station2 : this.control.getOwner().getStations()) {
            if (!station2.isWorkingArea()) continue;
            stations.put(station2.getStation(), station2);
        }
        if (dockable.asDockStation() != null && (station = (CStation)stations.get(dockable.asDockStation())) != null) {
            return station;
        }
        Object check = dockable;
        while (check != null) {
            DockStation parent = check.getDockParent();
            check = parent == null ? null : parent.asDockable();
            CStation station3 = (CStation)stations.get(parent);
            if (station3 == null) continue;
            return station3;
        }
        return null;
    }

    private CLocationMode getRepresentingMode(DockStation station) {
        Iterable modes = this.modes();
        CLocationMode first = null;
        for (CLocationMode mode : modes) {
            if (!mode.isRepresenting(station)) continue;
            if (mode.isBasicMode()) {
                return mode;
            }
            if (first != null) continue;
            first = mode;
        }
        return first;
    }
}

