/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.layout;

import java.awt.Dimension;

public class RequestDimension
implements Cloneable {
    private int width;
    private boolean widthSet;
    private int height;
    private boolean heightSet;

    public static RequestDimension requestWidth(int width) {
        return new RequestDimension(width, true);
    }

    public static RequestDimension requestHeight(int height) {
        return new RequestDimension(height, false);
    }

    public static RequestDimension request(int width, int height) {
        return new RequestDimension(width, height);
    }

    public RequestDimension() {
    }

    public RequestDimension(RequestDimension original) {
        this.width = original.width;
        this.widthSet = original.widthSet;
        this.height = original.height;
        this.heightSet = original.heightSet;
    }

    public RequestDimension(Dimension size) {
        this(size.width, size.height);
    }

    public RequestDimension(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public RequestDimension(int value, boolean valueIsWidth) {
        if (valueIsWidth) {
            this.setWidth(value);
        } else {
            this.setHeight(value);
        }
    }

    public void setWidth(int width) {
        this.width = width;
        this.widthSet = true;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isWidthSet() {
        return this.widthSet;
    }

    public void deleteWidth() {
        this.width = 0;
        this.widthSet = false;
    }

    public void setHeight(int height) {
        this.height = height;
        this.heightSet = true;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHeightSet() {
        return this.heightSet;
    }

    public void deleteHeight() {
        this.height = 0;
        this.heightSet = false;
    }

    public RequestDimension clone() {
        try {
            return (RequestDimension)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.getClass() + "[width=" + (this.widthSet ? String.valueOf(this.width) : "") + ", height=" + (this.heightSet ? String.valueOf(this.height) : "") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.heightSet ? 1231 : 1237);
        result = 31 * result + this.width;
        result = 31 * result + (this.widthSet ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestDimension other = (RequestDimension)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.heightSet != other.heightSet) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        return this.widthSet == other.widthSet;
    }
}

