/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableLocationListener;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CDockableLocationListenerManager;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.ControlVetoClosingListener;
import bibliothek.gui.dock.common.intern.action.CloseActionSource;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.VetoableDockFrontendEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCDockable
implements CDockable {
    private CLocation location = null;
    private CommonDockable dockable;
    private CStation<?> workingArea;
    private CControlAccess control;
    private String uniqueId;
    private boolean resizeLockedVertically = false;
    private boolean resizeLockedHorizontally = false;
    private boolean minimizeHold = false;
    private Dimension minimizeSize = new Dimension(-1, -1);
    private RequestDimension resizeRequest;
    private ColorMap colors = new ColorMap(this);
    private FontMap fonts = new FontMap(this);
    private Map<String, CAction> actions = new HashMap<String, CAction>();
    private boolean titleShown = true;
    private boolean singleTabShown = false;
    protected CListenerCollection listenerCollection = new CListenerCollection();
    private CDockableLocationListenerManager locationListenerManager;
    private ControlVetoClosingListener vetoClosingListenerConverter;
    private CloseActionSource close = new CloseActionSource(this);
    private Map<ExtendedMode, CLocation> defaultLocations = new HashMap<ExtendedMode, CLocation>(4);
    private Component focusComponent;

    protected AbstractCDockable() {
    }

    protected abstract CommonDockable createCommonDockable();

    protected void init(CommonDockable dockable) {
        if (this.dockable != null) {
            throw new IllegalStateException("dockable already set");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        this.dockable = dockable;
    }

    protected CloseActionSource getClose() {
        return this.close;
    }

    protected CControlAccess control() {
        return this.control;
    }

    @Override
    public void addCDockableStateListener(CDockableStateListener listener) {
        this.listenerCollection.addCDockableStateListener(listener);
    }

    @Override
    public void addCDockablePropertyListener(CDockablePropertyListener listener) {
        this.listenerCollection.addCDockablePropertyListener(listener);
    }

    @Override
    public void addCDockableLocationListener(CDockableLocationListener listener) {
        if (this.locationListenerManager == null) {
            this.locationListenerManager = new CDockableLocationListenerManager(this);
        }
        boolean has = this.listenerCollection.hasCDockableLocationListeners();
        this.listenerCollection.addCDockableLocationListener(listener);
        if (!has) {
            this.locationListenerManager.setListener(this.listenerCollection.getCDockableLocationListener());
        }
    }

    @Override
    public void removeCDockableStateListener(CDockableStateListener listener) {
        this.listenerCollection.removeCDockableStateListener(listener);
        if (this.locationListenerManager != null && !this.listenerCollection.hasCDockableLocationListeners()) {
            this.locationListenerManager.setListener(null);
        }
    }

    @Override
    public void removeCDockablePropertyListener(CDockablePropertyListener listener) {
        this.listenerCollection.removeCDockablePropertyListener(listener);
    }

    @Override
    public void removeCDockableLocationListener(CDockableLocationListener listener) {
        this.listenerCollection.removeCDockableLocationListener(listener);
    }

    @Override
    public void addFocusListener(CFocusListener listener) {
        this.listenerCollection.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(CFocusListener listener) {
        this.listenerCollection.removeFocusListener(listener);
    }

    @Override
    public void addKeyboardListener(CKeyboardListener listener) {
        this.listenerCollection.addKeyboardListener(listener);
    }

    @Override
    public void removeKeyboardListener(CKeyboardListener listener) {
        this.listenerCollection.removeKeyboardListener(listener);
    }

    @Override
    public void addDoubleClickListener(CDoubleClickListener listener) {
        this.listenerCollection.addDoubleClickListener(listener);
    }

    @Override
    public void removeDoubleClickListener(CDoubleClickListener listener) {
        this.listenerCollection.removeDoubleClickListener(listener);
    }

    @Override
    public void addVetoClosingListener(CVetoClosingListener listener) {
        boolean empty = !this.listenerCollection.hasVetoClosingListeners();
        this.listenerCollection.addVetoClosingListener(listener);
        if (empty && this.control != null) {
            this.control.getOwner().intern().addVetoableListener(this.getVetoClosingListenerConverter());
        }
    }

    @Override
    public void removeVetoClosingListener(CVetoClosingListener listener) {
        this.listenerCollection.removeVetoClosingListener(listener);
        if (!this.listenerCollection.hasVetoClosingListeners() && this.control != null && this.vetoClosingListenerConverter != null) {
            this.control.getOwner().intern().removeVetoableListener(this.vetoClosingListenerConverter);
            this.vetoClosingListenerConverter = null;
        }
    }

    private ControlVetoClosingListener getVetoClosingListenerConverter() {
        if (this.vetoClosingListenerConverter == null) {
            this.vetoClosingListenerConverter = new ControlVetoClosingListener(this.control.getOwner(), this.listenerCollection.getVetoClosingListener()){

                protected CDockable[] getCDockables(VetoableDockFrontendEvent event) {
                    for (Dockable dockable : event) {
                        if (dockable != AbstractCDockable.this.intern()) continue;
                        return new CDockable[]{AbstractCDockable.this};
                    }
                    return null;
                }
            };
        }
        return this.vetoClosingListenerConverter;
    }

    @Deprecated
    protected CDockableStateListener[] stateListeners() {
        return this.listenerCollection.getCDockableStateListeners();
    }

    @Deprecated
    protected CDockablePropertyListener[] propertyListeners() {
        return this.listenerCollection.getCDockablePropertyListeners();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.control == null) {
            throw new IllegalStateException("This CDockable does not know its CControl. Call CControl.add(...) to connect this CDockable befor calling setVisible(...).");
        }
        if (visible) {
            this.control.show(this);
        } else {
            this.control.hide(this);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.control == null) {
            return false;
        }
        return this.control.isVisible(this);
    }

    @Override
    public boolean hasParent() {
        if (this.control == null) {
            return false;
        }
        return this.control.hasParent(this);
    }

    @Override
    public boolean isDockableVisible() {
        return this.intern().isDockableVisible();
    }

    public void toFront() {
        if (this.isVisible()) {
            this.control.getOwner().intern().getController().setFocusedDockable((Dockable)this.intern(), null, false);
        }
    }

    @Override
    public void setLocation(CLocation location) {
        this.location = location;
        if (location != null && this.control != null && this.isVisible()) {
            this.control.getLocationManager().setLocation(this.intern(), location);
            this.location = null;
        }
    }

    @Override
    public CLocation getBaseLocation() {
        if (this.control != null && this.isVisible()) {
            return this.control.getLocationManager().getLocation(this.intern());
        }
        return this.location;
    }

    @Override
    public void setExtendedMode(ExtendedMode extendedMode) {
        if (extendedMode == null) {
            throw new NullPointerException("extendedMode must not be null");
        }
        if (extendedMode == ExtendedMode.EXTERNALIZED && !this.isExternalizable()) {
            return;
        }
        if (extendedMode == ExtendedMode.MINIMIZED && !this.isMinimizable()) {
            return;
        }
        if (extendedMode == ExtendedMode.MAXIMIZED && !this.isMaximizable()) {
            return;
        }
        CControlAccess control = this.control();
        if (control != null) {
            control.getLocationManager().setMode(this.intern(), extendedMode);
        }
    }

    @Override
    public ExtendedMode getExtendedMode() {
        CControlAccess control = this.control();
        if (control == null) {
            return null;
        }
        return control.getLocationManager().getMode(this.intern());
    }

    @Override
    public void setWorkingArea(CStation<?> area) {
        this.workingArea = area;
    }

    @Override
    public CStation<?> getWorkingArea() {
        return this.workingArea;
    }

    public boolean isResizeLocked() {
        return this.resizeLockedVertically && this.resizeLockedHorizontally;
    }

    @Override
    public boolean isResizeLockedVertically() {
        return this.resizeLockedVertically;
    }

    @Override
    public boolean isResizeLockedHorizontally() {
        return this.resizeLockedHorizontally;
    }

    public void setResizeRequest(Dimension size, boolean process) {
        RequestDimension requestDimension = this.resizeRequest = size == null ? null : new RequestDimension(size);
        if (process && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    public void setResizeRequest(RequestDimension size, boolean process) {
        RequestDimension requestDimension = this.resizeRequest = size == null ? null : new RequestDimension(size);
        if (process && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    @Override
    public RequestDimension getAndClearResizeRequest() {
        RequestDimension result = this.resizeRequest;
        this.resizeRequest = null;
        return result;
    }

    public void setResizeLocked(boolean resizeLocked) {
        if (this.isResizeLocked() != resizeLocked) {
            this.resizeLockedHorizontally = resizeLocked;
            this.resizeLockedVertically = resizeLocked;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedHorizontally(boolean resizeLockedHorizontally) {
        if (this.resizeLockedHorizontally != resizeLockedHorizontally) {
            this.resizeLockedHorizontally = resizeLockedHorizontally;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedVertically(boolean resizeLockedVertically) {
        if (this.resizeLockedVertically != resizeLockedVertically) {
            this.resizeLockedVertically = resizeLockedVertically;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    @Override
    public void setMinimizedHold(boolean hold) {
        if (this.minimizeHold != hold) {
            this.minimizeHold = hold;
            this.listenerCollection.getCDockablePropertyListener().minimizedHoldChanged(this);
        }
    }

    @Override
    public boolean isMinimizedHold() {
        return this.minimizeHold;
    }

    @Override
    public void setMinimizedSize(Dimension size) {
        this.minimizeSize = new Dimension(size.width, size.height);
        this.listenerCollection.getCDockablePropertyListener().minimizeSizeChanged(this);
    }

    @Override
    public Dimension getMinimizedSize() {
        return new Dimension(this.minimizeSize.width, this.minimizeSize.height);
    }

    public void setTitleShown(boolean shown) {
        if (this.titleShown != shown) {
            this.titleShown = shown;
            this.listenerCollection.getCDockablePropertyListener().titleShownChanged(this);
        }
    }

    @Override
    public boolean isTitleShown() {
        return this.titleShown;
    }

    public void setSingleTabShown(boolean singleTabShown) {
        if (this.singleTabShown != singleTabShown) {
            this.singleTabShown = singleTabShown;
            this.listenerCollection.getCDockablePropertyListener().singleTabShownChanged(this);
        }
    }

    @Override
    public boolean isSingleTabShown() {
        return this.singleTabShown;
    }

    @Override
    public CommonDockable intern() {
        if (this.dockable == null) {
            this.init(this.createCommonDockable());
        }
        return this.dockable;
    }

    public void setDefaultLocation(ExtendedMode mode, CLocation location) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (location == null) {
            this.defaultLocations.remove(mode);
        } else {
            CLocationModeManager state;
            ExtendedMode locationMode = location.findMode();
            if (locationMode == null) {
                throw new IllegalArgumentException("location does not carry enough information to find its mode");
            }
            if (!mode.getModeIdentifier().equals((Object)locationMode.getModeIdentifier())) {
                throw new IllegalArgumentException("mode of location and 'mode' do not have the same identifier");
            }
            this.defaultLocations.put(mode, location);
            if (this.control != null && (state = this.control.getLocationManager()).getLocation(this.intern(), mode) == null) {
                state.setLocation(this.intern(), mode, location);
            }
        }
    }

    public CLocation getDefaultLocation(ExtendedMode mode) {
        return this.defaultLocations.get(mode);
    }

    @Override
    public void setControl(CControlAccess control) {
        if (this.control == control) {
            return;
        }
        if (this.control != null) {
            if (this.control.shouldStore(this) == null) {
                this.control.getLocationManager().remove(this.intern());
            } else {
                this.control.getLocationManager().reduceToEmpty(this.intern());
            }
            this.control.getLocationManager().remove(this.intern());
            this.control.link(this, null);
            if (this.vetoClosingListenerConverter != null) {
                this.control.getOwner().intern().removeVetoableListener(this.vetoClosingListenerConverter);
                this.vetoClosingListenerConverter = null;
            }
        }
        this.control = control;
        if (control != null) {
            if (this.uniqueId != null) {
                control.getLocationManager().add(this.uniqueId, this.intern());
            }
            if (this.listenerCollection.hasVetoClosingListeners()) {
                control.getOwner().intern().addVetoableListener(this.getVetoClosingListenerConverter());
            }
            control.link(this, new CDockableAccess(){
                private ExtendedMode currentMode;

                public void informVisibility(boolean visible) {
                    AbstractCDockable.this.listenerCollection.getCDockableStateListener().visibilityChanged(AbstractCDockable.this);
                }

                public void informMode(ExtendedMode mode) {
                    if (this.currentMode != mode) {
                        this.currentMode = mode;
                        CDockableStateListener forward = AbstractCDockable.this.listenerCollection.getCDockableStateListener();
                        forward.extendedModeChanged(AbstractCDockable.this, mode);
                    }
                }

                public CFocusListener getFocusListener() {
                    return AbstractCDockable.this.listenerCollection.getFocusListener();
                }

                public CKeyboardListener getKeyboardListener() {
                    return AbstractCDockable.this.listenerCollection.getKeyboardListener();
                }

                public CDoubleClickListener getDoubleClickListener() {
                    return AbstractCDockable.this.listenerCollection.getDoubleClickListener();
                }

                public void setUniqueId(String id) {
                    if (id != null && !id.equals(AbstractCDockable.this.uniqueId) || id == null && AbstractCDockable.this.uniqueId != null) {
                        CLocationModeManager manager;
                        if (AbstractCDockable.this.control != null && AbstractCDockable.this.uniqueId != null) {
                            manager = AbstractCDockable.this.control.getLocationManager();
                            manager.remove(AbstractCDockable.this.intern());
                        }
                        AbstractCDockable.this.uniqueId = id;
                        if (AbstractCDockable.this.control != null && id != null) {
                            manager = AbstractCDockable.this.control.getLocationManager();
                            manager.put(AbstractCDockable.this.uniqueId, AbstractCDockable.this.intern());
                            for (Map.Entry location : AbstractCDockable.this.defaultLocations.entrySet()) {
                                if (manager.getLocation(AbstractCDockable.this.intern(), (ExtendedMode)location.getKey()) != null) continue;
                                manager.setLocation(AbstractCDockable.this.intern(), (ExtendedMode)location.getKey(), (CLocation)location.getValue());
                            }
                        }
                    }
                }

                public String getUniqueId() {
                    return AbstractCDockable.this.uniqueId;
                }

                public CLocation internalLocation() {
                    CLocation loc = AbstractCDockable.this.location;
                    AbstractCDockable.this.location = null;
                    return loc;
                }
            });
        }
        this.close.setControl(control);
    }

    public void putAction(String key, CAction action) {
        CAction old = this.actions.put(key, action);
        if (old != action) {
            this.listenerCollection.getCDockablePropertyListener().actionChanged(this, key, old, action);
        }
    }

    @Override
    public CAction getAction(String key) {
        return this.actions.get(key);
    }

    @Override
    public ColorMap getColors() {
        return this.colors;
    }

    @Override
    public FontMap getFonts() {
        return this.fonts;
    }

    @Override
    public Component getFocusComponent() {
        return this.focusComponent;
    }

    public void setFocusComponent(Component component) {
        this.focusComponent = component;
    }

    @Override
    public CControlAccess getControl() {
        return this.control;
    }
}

