/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class ShapePainter
extends AbstractAreaPainter<Object> {
    private Shape shape;

    public ShapePainter() {
        this.shape = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        this.setBorderWidth(3.0f);
        this.setFillPaint(Color.RED);
        this.setBorderPaint(Color.BLACK);
    }

    public ShapePainter(Shape shape) {
        this.shape = shape;
    }

    public ShapePainter(Shape shape, Paint paint) {
        this.shape = shape;
        this.setFillPaint(paint);
    }

    public ShapePainter(Shape shape, Paint paint, AbstractAreaPainter.Style style) {
        this.shape = shape;
        this.setFillPaint(paint);
        this.setStyle(style == null ? AbstractAreaPainter.Style.BOTH : style);
    }

    public void setShape(Shape s) {
        Shape old = this.getShape();
        this.shape = s;
        this.setDirty(true);
        this.firePropertyChange("shape", old, this.getShape());
    }

    public Shape getShape() {
        return this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPaint(Graphics2D g, Object component, int w, int h) {
        BasicStroke s = new BasicStroke(this.getBorderWidth());
        g.setStroke(s);
        if (this.getShape() == null) return;
        Shape shape = this.provideShape(g, component, w, h);
        Rectangle bounds = shape.getBounds();
        Rectangle rect = this.calculateLayout(bounds.width, bounds.height, w, h);
        g = (Graphics2D)g.create();
        try {
            g.translate(rect.x, rect.y);
            this.drawPathEffects(g, shape, rect.width, rect.height);
            switch (this.getStyle()) {
                case BOTH: {
                    this.drawShape(g, shape, component, rect.width, rect.height);
                    this.fillShape(g, shape, component, rect.width, rect.height);
                    return;
                }
                case FILLED: {
                    this.fillShape(g, shape, component, rect.width, rect.height);
                    return;
                }
                case OUTLINE: {
                    this.drawShape(g, shape, component, rect.width, rect.height);
                    return;
                }
            }
            return;
        }
        finally {
            g.dispose();
        }
    }

    private void drawShape(Graphics2D g, Shape shape, Object component, int w, int h) {
        g.setPaint(this.calculateStrokePaint(component, w, h));
        g.draw(shape);
    }

    private void fillShape(Graphics2D g, Shape shape, Object component, int w, int h) {
        g.setPaint(this.calculateFillPaint(component, w, h));
        g.fill(shape);
    }

    @Override
    protected Shape provideShape(Graphics2D g, Object comp, int width, int height) {
        return this.getShape();
    }

    private Paint calculateStrokePaint(Object component, int width, int height) {
        Paint p = this.getBorderPaint();
        if (p == null && component instanceof JComponent) {
            p = ((JComponent)component).getForeground();
        }
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        return p;
    }

    private Paint calculateFillPaint(Object component, int width, int height) {
        Paint p = this.getFillPaint();
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        if (p == null && component instanceof JComponent) {
            p = ((JComponent)component).getBackground();
        }
        return p;
    }

    private void drawPathEffects(Graphics2D g, Shape shape, int w, int h) {
        if (this.getAreaEffects() != null) {
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g, shape, w, h);
            }
        }
    }
}

