/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.StringValues;

public abstract class ComponentAdapter {
    public static final Object DEFAULT_COLUMN_IDENTIFIER = "Column0";
    public int row = 0;
    public int column = 0;
    protected final JComponent target;

    public ComponentAdapter(JComponent component) {
        this.target = component;
    }

    public JComponent getComponent() {
        return this.target;
    }

    public String getColumnName(int columnIndex) {
        Object identifier = this.getColumnIdentifierAt(columnIndex);
        return identifier != null ? identifier.toString() : null;
    }

    public Object getColumnIdentifierAt(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("invalid column index: " + columnIndex);
        }
        return DEFAULT_COLUMN_IDENTIFIER;
    }

    public int getColumnIndex(Object identifier) {
        if (identifier.equals(this.getColumnIdentifierAt(0))) {
            return 0;
        }
        return -1;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return 0;
    }

    public abstract Object getValueAt(int var1, int var2);

    public abstract boolean isCellEditable(int var1, int var2);

    public boolean isTestable(int column) {
        return this.convertColumnIndexToView(column) >= 0;
    }

    public String getString() {
        return this.getString(this.convertColumnIndexToModel(this.column));
    }

    public String getString(int modelColumnIndex) {
        return this.getFilteredStringAt(this.row, modelColumnIndex);
    }

    public String getFilteredStringAt(int row, int column) {
        return this.getStringAt(this.convertRowIndexToModel(row), column);
    }

    public String getStringAt(int row, int column) {
        return StringValues.TO_STRING.getString(this.getValueAt(row, column));
    }

    public Object getValue() {
        return this.getValue(this.convertColumnIndexToModel(this.column));
    }

    public Object getValue(int modelColumnIndex) {
        return this.getFilteredValueAt(this.row, modelColumnIndex);
    }

    public Object getFilteredValueAt(int row, int column) {
        return this.getValueAt(this.convertRowIndexToModel(row), column);
    }

    public Rectangle getCellBounds() {
        return this.target.getBounds();
    }

    public abstract boolean hasFocus();

    public abstract boolean isSelected();

    public abstract boolean isEditable();

    public boolean isExpanded() {
        return true;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isHierarchical() {
        return false;
    }

    public int getDepth() {
        return 1;
    }

    public int convertColumnIndexToView(int columnModelIndex) {
        return columnModelIndex;
    }

    public int convertColumnIndexToModel(int columnViewIndex) {
        return columnViewIndex;
    }

    public int convertRowIndexToView(int rowModelIndex) {
        return rowModelIndex;
    }

    public int convertRowIndexToModel(int rowViewIndex) {
        return rowViewIndex;
    }

    public void refresh() {
        this.target.revalidate();
        this.target.repaint();
    }
}

