/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class NumericEntityUnescaper
extends CharSequenceTranslator {
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        if (input.charAt(index) == '&' && input.charAt(index + 1) == '#') {
            int entityValue;
            int start = index + 2;
            boolean isHex = false;
            char firstChar = input.charAt(start);
            if (firstChar == 'x' || firstChar == 'X') {
                ++start;
                isHex = true;
            }
            int end = start;
            while (input.charAt(end) != ';') {
                ++end;
            }
            try {
                entityValue = isHex ? Integer.parseInt(((Object)input.subSequence(start, end)).toString(), 16) : Integer.parseInt(((Object)input.subSequence(start, end)).toString(), 10);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            if (entityValue > 65535) {
                char[] chrs = Character.toChars(entityValue);
                out.write(chrs[0]);
                out.write(chrs[1]);
            } else {
                out.write(entityValue);
            }
            return 2 + (end - start) + (isHex ? 1 : 0) + 1;
        }
        return 0;
    }
}

