/*
 * Decompiled with CFR 0.152.
 */
package test;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Dock9
extends JFrame {
    private DockController controller = new DockController();
    private SplitDockStation station;
    private Dockable center;

    public static void main(String[] args) {
        Dock9 dock = new Dock9();
        dock.setDefaultCloseOperation(3);
        dock.setBounds(20, 20, 400, 400);
        dock.setVisible(true);
    }

    public Dock9() {
        this.controller.setTheme((DockTheme)new EclipseTheme());
        this.controller.getProperties().set(EclipseTheme.THEME_CONNECTOR, (Object)new DefaultEclipseThemeConnector(){

            public EclipseThemeConnector.TitleBar getTitleBarKind(Dockable dockable) {
                if (dockable == Dock9.this.center) {
                    return EclipseThemeConnector.TitleBar.NONE_BORDERED;
                }
                return super.getTitleBarKind(dockable);
            }
        });
        this.station = new SplitDockStation(){

            public boolean canDrag(Dockable dockable) {
                return dockable != Dock9.this.center;
            }
        };
        this.controller.add((DockStation)this.station);
        this.setLayout(new BorderLayout());
        this.add(this.station.getComponent(), "Center");
        JPanel buttons = new JPanel(new GridLayout(1, 4));
        buttons.add(this.button(Side.LEFT));
        buttons.add(this.button(Side.RIGHT));
        buttons.add(this.button(Side.TOP));
        buttons.add(this.button(Side.BOTTOM));
        this.add((Component)buttons, "North");
        this.center = new DefaultDockable(new JLabel("CENTER")){

            public boolean accept(DockStation base, Dockable neighbour) {
                return false;
            }
        };
        this.station.drop(this.center);
    }

    private JButton button(final Side side) {
        JButton button = new JButton(side.toString());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultDockable dockable = new DefaultDockable(side.toString());
                Dock9.this.drop((Dockable)dockable, side);
            }
        });
        return button;
    }

    private void drop(Dockable dockable, Side side) {
        Leaf leaf = this.find((SplitNode)this.station.getRoot(), side);
        if (leaf != null && !this.aside(leaf, side)) {
            leaf = null;
        }
        if (leaf == null) {
            switch (side) {
                case BOTTOM: {
                    this.drop(dockable, SplitDockProperty.SOUTH);
                    break;
                }
                case TOP: {
                    this.drop(dockable, SplitDockProperty.NORTH);
                    break;
                }
                case LEFT: {
                    this.drop(dockable, SplitDockProperty.WEST);
                    break;
                }
                case RIGHT: {
                    this.drop(dockable, SplitDockProperty.EAST);
                }
            }
        } else {
            DockStation stack = leaf.getDockable().asDockStation();
            if (stack == null) {
                this.station.drop(dockable, this.station.getDockableProperty(leaf.getDockable(), dockable));
            } else {
                stack.drop(dockable);
            }
        }
    }

    private void drop(Dockable dockable, SplitDockProperty property) {
        if (!this.station.drop(dockable, property)) {
            this.station.drop(dockable);
        }
    }

    private boolean aside(Leaf leaf, Side side) {
        Leaf center = this.station.getRoot().getLeaf(this.center);
        switch (side) {
            case TOP: {
                return leaf.getY() + leaf.getHeight() <= center.getY();
            }
            case BOTTOM: {
                return leaf.getY() >= center.getY() + center.getHeight();
            }
            case LEFT: {
                return leaf.getX() + leaf.getWidth() <= center.getX();
            }
            case RIGHT: {
                return leaf.getX() >= center.getX() + center.getHeight();
            }
        }
        return false;
    }

    private Leaf find(SplitNode parent, Side side) {
        Leaf leaf;
        if (parent instanceof Leaf && (leaf = (Leaf)parent).getDockable() != this.center) {
            return leaf;
        }
        if (parent instanceof Node) {
            Node node = (Node)parent;
            Leaf left = this.find(node.getLeft(), side);
            Leaf right = this.find(node.getRight(), side);
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            switch (side) {
                case LEFT: {
                    if (left.getX() + left.getWidth() / 2.0 < right.getX() + right.getWidth() / 2.0) {
                        return left;
                    }
                    return right;
                }
                case RIGHT: {
                    if (left.getX() + left.getWidth() / 2.0 > right.getX() + right.getWidth() / 2.0) {
                        return left;
                    }
                    return right;
                }
                case TOP: {
                    if (left.getY() + left.getHeight() / 2.0 < right.getY() + right.getHeight() / 2.0) {
                        return left;
                    }
                    return right;
                }
                case BOTTOM: {
                    if (left.getY() + left.getHeight() / 2.0 > right.getY() + right.getHeight() / 2.0) {
                        return left;
                    }
                    return right;
                }
            }
        }
        if (parent instanceof Root) {
            return this.find(((Root)parent).getChild(), side);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

