/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class DateTime
implements OdfDataType {
    private XMLGregorianCalendar mDateTime;

    public DateTime(XMLGregorianCalendar dateTime) throws IllegalArgumentException {
        if (dateTime == null) {
            throw new IllegalArgumentException("parameter can not be null for DateTime");
        }
        if (!W3CSchemaType.isValid("dateTime", dateTime.toXMLFormat())) {
            throw new IllegalArgumentException("parameter is invalid for datatype dateTime");
        }
        this.mDateTime = dateTime;
    }

    public String toString() {
        return this.mDateTime.toXMLFormat();
    }

    public static DateTime valueOf(String stringValue) throws IllegalArgumentException {
        try {
            DatatypeFactoryImpl aFactory = new DatatypeFactoryImpl();
            return new DateTime(aFactory.newXMLGregorianCalendar(stringValue));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(DateTime.class.getName()).log(Level.SEVERE, "parameter is invalid for datatype DateTime", ex);
            throw new IllegalArgumentException("parameter is invalid for datatype DateTime");
        }
    }

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        return this.mDateTime;
    }

    public static boolean isValid(XMLGregorianCalendar date) {
        if (date == null) {
            return false;
        }
        return W3CSchemaType.isValid("dateTime", date.toString());
    }
}

