/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.draw;

import java.util.Hashtable;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.doc.presentation.OdfPresentationNotes;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.w3c.dom.NodeList;

public class OdfDrawPage {
    DrawPageElement maSlideElement;
    private static Hashtable<DrawPageElement, OdfDrawPage> maSlideRepository = new Hashtable();

    private OdfDrawPage(DrawPageElement pageElement) {
        this.maSlideElement = pageElement;
    }

    public static OdfDrawPage getInstance(DrawPageElement pageElement) {
        if (maSlideRepository.containsKey(pageElement)) {
            return maSlideRepository.get(pageElement);
        }
        OdfDrawPage newSlide = new OdfDrawPage(pageElement);
        maSlideRepository.put(pageElement, newSlide);
        return newSlide;
    }

    public DrawPageElement getOdfElement() {
        return this.maSlideElement;
    }

    public int getSlideIndex() {
        OdfFileDom contentDom = (OdfFileDom)((Object)this.maSlideElement.getOwnerDocument());
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)((Object)slideNodes.item(i));
            if (slideEle != this.maSlideElement) continue;
            return i;
        }
        return -1;
    }

    public String getSlideName() {
        String slideName = this.maSlideElement.getDrawNameAttribute();
        if (slideName == null) {
            slideName = this.makeUniqueSlideName();
            this.maSlideElement.setDrawNameAttribute(slideName);
        }
        return slideName;
    }

    public void setSlideName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("slide name is null is not accepted in the presentation document");
        }
        OdfFileDom contentDom = (OdfFileDom)((Object)this.maSlideElement.getOwnerDocument());
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.DRAW).toString(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)((Object)slideNodes.item(i));
            OdfDrawPage slide = OdfDrawPage.getInstance(slideEle);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            throw new IllegalArgumentException("the given slide name is already exist in the current presentation document");
        }
        this.maSlideElement.setDrawNameAttribute(name);
    }

    public OdfPresentationNotes getNotesPage() {
        NodeList notesList = this.maSlideElement.getElementsByTagNameNS(OdfNamespace.newNamespace(OdfNamespaceNames.PRESENTATION).toString(), "notes");
        if (notesList.getLength() > 0) {
            PresentationNotesElement noteEle = (PresentationNotesElement)((Object)notesList.item(0));
            return OdfPresentationNotes.getInstance(noteEle);
        }
        return null;
    }

    private String makeUniqueSlideName() {
        int index = this.getSlideIndex();
        String slideName = "page" + (index + 1) + "-" + String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        return slideName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlideLayout {
        BLANK("blank"),
        TITLE_ONLY("title_only"),
        TITLE_OUTLINE("title_outline"),
        TITLE_PLUS_TEXT("title_text"),
        TITLE_PLUS_2_TEXT_BLOCK("title_two_text_block");

        private String mValue;

        private SlideLayout(String aValue) {
            this.mValue = aValue;
        }

        public String toString() {
            return this.mValue;
        }

        public static String toString(SlideLayout aEnum) {
            return aEnum.toString();
        }

        public static SlideLayout enumValueOf(String aString) {
            for (SlideLayout aIter : SlideLayout.values()) {
                if (!aString.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }
}

