/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.List;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparatingMenuPiece
extends MenuPiece {
    private boolean topSeparator = false;
    private boolean bottomSeparator = false;
    private boolean emptySeparator = false;
    private Component separatorTop = null;
    private Component separatorBottom = null;
    private MenuPiece piece;
    private Listener listener = new Listener();

    public SeparatingMenuPiece() {
        this(null);
    }

    public SeparatingMenuPiece(boolean bl, boolean bl2, boolean bl3) {
        this(null, bl, bl2, bl3);
    }

    public SeparatingMenuPiece(MenuPiece menuPiece) {
        this(menuPiece, false, false, false);
    }

    public SeparatingMenuPiece(MenuPiece menuPiece, boolean bl, boolean bl2, boolean bl3) {
        this.setPiece(menuPiece);
        this.setTopSeparator(bl);
        this.setEmptySeparator(bl2);
        this.setBottomSeparator(bl3);
    }

    public MenuPiece getPiece() {
        return this.piece;
    }

    public void setPiece(MenuPiece menuPiece) {
        if (this.piece != menuPiece) {
            if (this.piece != null) {
                this.listener.remove(menuPiece, 0, menuPiece.getItemCount());
                this.piece.setParent(null);
                menuPiece.removeListener(this.listener);
            }
            this.piece = menuPiece;
            if (this.piece != null) {
                menuPiece.setParent(this);
                menuPiece.addListener(this.listener);
                this.listener.insert(menuPiece, 0, menuPiece.items());
            }
        }
    }

    @Override
    public int getItemCount() {
        if (this.piece == null) {
            return this.getSeparatorCount();
        }
        return this.piece.getItemCount() + this.getSeparatorCount();
    }

    @Override
    public void fill(List<Component> list) {
        if (this.piece == null || this.piece.getItemCount() == 0) {
            if (this.emptySeparator) {
                list.add(this.getEmptySeparator());
            }
        } else {
            if (this.topSeparator) {
                list.add(this.getTopSeparator());
            }
            this.piece.fill(list);
            if (this.bottomSeparator) {
                list.add(this.getBottomSeparator());
            }
        }
    }

    protected int getSeparatorCount() {
        if (this.piece != null && this.piece.getItemCount() > 0) {
            if (this.topSeparator && this.bottomSeparator) {
                return 2;
            }
            if (this.topSeparator || this.bottomSeparator) {
                return 1;
            }
            return 0;
        }
        if (this.emptySeparator) {
            return 1;
        }
        return 0;
    }

    public boolean isBottomSeparator() {
        return this.bottomSeparator;
    }

    public void setBottomSeparator(boolean bl) {
        if (this.bottomSeparator != bl) {
            this.bottomSeparator = bl;
            this.putUpSeparators();
            MenuPiece menuPiece = this.getParent();
            if (menuPiece != null && this.piece != null && this.piece.getItemCount() > 0) {
                if (bl) {
                    this.fireInsert(this.getItemCount(), this.getBottomSeparator());
                } else {
                    this.fireRemove(this.getItemCount() - 1, 1);
                }
            }
        }
    }

    public boolean isEmptySeparator() {
        return this.emptySeparator;
    }

    public void setEmptySeparator(boolean bl) {
        if (this.emptySeparator != bl) {
            this.emptySeparator = bl;
            this.putUpSeparators();
            if (this.piece == null || this.piece.getItemCount() == 0) {
                if (bl) {
                    this.fireInsert(0, this.getEmptySeparator());
                } else {
                    this.fireRemove(0, 1);
                }
            }
        }
    }

    public boolean isTopSeparator() {
        return this.topSeparator;
    }

    public void setTopSeparator(boolean bl) {
        if (this.topSeparator != bl) {
            this.topSeparator = bl;
            this.putUpSeparators();
            if (this.piece != null && this.piece.getItemCount() > 0) {
                if (bl) {
                    this.fireInsert(0, this.getTopSeparator());
                } else {
                    this.fireRemove(0, 1);
                }
            }
        }
    }

    private Component getTopSeparator() {
        return this.separatorTop;
    }

    private Component getBottomSeparator() {
        return this.separatorBottom;
    }

    private Component getEmptySeparator() {
        if (this.separatorTop != null) {
            return this.separatorTop;
        }
        return this.separatorBottom;
    }

    private void putUpSeparators() {
        boolean bl = this.topSeparator;
        boolean bl2 = this.bottomSeparator;
        if (this.emptySeparator && !bl && !bl2) {
            bl = true;
        }
        if (bl && this.separatorTop == null) {
            this.separatorTop = new JPopupMenu.Separator();
        } else if (!bl && this.separatorTop != null) {
            this.separatorTop = null;
        }
        if (bl2 && this.separatorBottom == null) {
            this.separatorBottom = new JPopupMenu.Separator();
        } else if (!bl && this.separatorBottom != null) {
            this.separatorBottom = null;
        }
    }

    private class Listener
    implements MenuPieceListener {
        private Listener() {
        }

        public void insert(MenuPiece menuPiece, int n, Component ... componentArray) {
            if (componentArray.length > 0) {
                int n2 = SeparatingMenuPiece.this.piece.getItemCount() - componentArray.length;
                if (n2 == 0) {
                    if (SeparatingMenuPiece.this.emptySeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 1);
                    }
                    if (SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getBottomSeparator());
                    }
                    if (SeparatingMenuPiece.this.topSeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getTopSeparator());
                    }
                }
                if (SeparatingMenuPiece.this.topSeparator) {
                    ++n;
                }
                SeparatingMenuPiece.this.fireInsert(n, componentArray);
            }
        }

        public void remove(MenuPiece menuPiece, int n, int n2) {
            if (n2 > 0) {
                if (SeparatingMenuPiece.this.topSeparator) {
                    ++n;
                }
                SeparatingMenuPiece.this.fireRemove(n, n2);
                if (menuPiece.getItemCount() == 0) {
                    if (SeparatingMenuPiece.this.topSeparator && SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 2);
                    }
                    if (SeparatingMenuPiece.this.topSeparator || SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 1);
                    }
                    if (SeparatingMenuPiece.this.emptySeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getEmptySeparator());
                    }
                }
            }
        }
    }
}

