/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.layout;

import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeLeaf;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullLockConflictResolver
extends DefaultConflictResolver<RequestDimension> {
    @Override
    public double resolveHorizontal(ResizeNode<RequestDimension> resizeNode, ResizeRequest resizeRequest, double d, ResizeRequest resizeRequest2, double d2) {
        if (resizeRequest.getFractionWidth() == 1 && resizeRequest2.getFractionWidth() == 1) {
            boolean bl = this.checkHorizontalFullLock(resizeNode.getLeft());
            boolean bl2 = this.checkHorizontalFullLock(resizeNode.getRight());
            if (!bl && bl2) {
                return d2;
            }
            if (bl && !bl2) {
                return d;
            }
        }
        return super.resolveHorizontal(resizeNode, resizeRequest, d, resizeRequest2, d2);
    }

    @Override
    public double resolveVertical(ResizeNode<RequestDimension> resizeNode, ResizeRequest resizeRequest, double d, ResizeRequest resizeRequest2, double d2) {
        if (resizeRequest.getFractionWidth() == 1 && resizeRequest2.getFractionWidth() == 1) {
            boolean bl = this.checkVerticalFullLock(resizeNode.getLeft());
            boolean bl2 = this.checkVerticalFullLock(resizeNode.getRight());
            if (!bl && bl2) {
                return d2;
            }
            if (bl && !bl2) {
                return d;
            }
        }
        return super.resolveVertical(resizeNode, resizeRequest, d, resizeRequest2, d2);
    }

    protected boolean checkHorizontalFullLock(ResizeElement<RequestDimension> resizeElement) {
        ResizeLeaf resizeLeaf;
        ResizeRequest resizeRequest;
        if (resizeElement instanceof ResizeNode) {
            ResizeNode resizeNode = (ResizeNode)resizeElement;
            ResizeRequest resizeRequest2 = resizeNode.getLeft().getRequest();
            ResizeRequest resizeRequest3 = resizeNode.getRight().getRequest();
            if (resizeRequest2 == null || resizeRequest2.getFractionWidth() == -1) {
                return false;
            }
            if (resizeRequest3 == null || resizeRequest3.getFractionWidth() == -1) {
                return false;
            }
            if (!this.checkHorizontalFullLock(resizeNode.getLeft())) {
                return false;
            }
            if (!this.checkHorizontalFullLock(resizeNode.getRight())) {
                return false;
            }
        } else if (resizeElement instanceof ResizeLeaf && ((resizeRequest = (resizeLeaf = (ResizeLeaf)resizeElement).getRequest()) == null || resizeRequest.getFractionWidth() == -1)) {
            return false;
        }
        return true;
    }

    protected boolean checkVerticalFullLock(ResizeElement<RequestDimension> resizeElement) {
        ResizeLeaf resizeLeaf;
        ResizeRequest resizeRequest;
        if (resizeElement instanceof ResizeNode) {
            ResizeNode resizeNode = (ResizeNode)resizeElement;
            ResizeRequest resizeRequest2 = resizeNode.getLeft().getRequest();
            ResizeRequest resizeRequest3 = resizeNode.getRight().getRequest();
            if (resizeRequest2 == null || resizeRequest2.getFractionHeight() == -1) {
                return false;
            }
            if (resizeRequest3 == null || resizeRequest3.getFractionHeight() == -1) {
                return false;
            }
            if (!this.checkVerticalFullLock(resizeNode.getLeft())) {
                return false;
            }
            if (!this.checkVerticalFullLock(resizeNode.getRight())) {
                return false;
            }
        } else if (resizeElement instanceof ResizeLeaf && ((resizeRequest = (resizeLeaf = (ResizeLeaf)resizeElement).getRequest()) == null || resizeRequest.getFractionHeight() == -1)) {
            return false;
        }
        return true;
    }
}

