/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.font;

import bibliothek.gui.dock.util.font.FontModifier;
import java.awt.Font;

public class GenericFontModifier
implements FontModifier {
    private Modify italic = Modify.IGNORE;
    private Modify bold = Modify.IGNORE;
    private boolean sizeDelta = true;
    private int size = 0;

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSizeDelta(boolean bl) {
        this.sizeDelta = bl;
    }

    public boolean isSizeDelta() {
        return this.sizeDelta;
    }

    public void setItalic(Modify modify) {
        this.italic = modify;
    }

    public Modify getItalic() {
        return this.italic;
    }

    public void setBold(Modify modify) {
        this.bold = modify;
    }

    public Modify getBold() {
        return this.bold;
    }

    public Font modify(Font font) {
        int n = 0;
        if (font.isBold()) {
            n |= 1;
        }
        if (font.isItalic()) {
            n |= 2;
        }
        int n2 = this.modify(n, 2, this.italic);
        n2 = this.modify(n2, 1, this.bold);
        float f = this.size;
        if (this.sizeDelta) {
            f += (float)font.getSize();
        }
        return font.deriveFont(n2, f);
    }

    private int modify(int n, int n2, Modify modify) {
        switch (modify) {
            case IGNORE: {
                return n;
            }
            case ON: {
                return n | n2;
            }
            case OFF: {
                return n & ~n2;
            }
            case REVERSE: {
                return n ^ n2;
            }
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modify {
        ON,
        OFF,
        REVERSE,
        IGNORE;

    }
}

