/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.NullTitleFactory;
import bibliothek.gui.dock.util.Priority;
import java.util.Hashtable;
import java.util.Map;

public class DockTitleManager {
    public static final String THEME_FACTORY_ID = "theme";
    private Map<String, DockTitleVersion> titleVersions = new Hashtable<String, DockTitleVersion>();
    private DockController controller;

    public DockTitleManager(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.controller = dockController;
        this.getVersion(THEME_FACTORY_ID, NullTitleFactory.INSTANCE);
    }

    public boolean existsTitleVersion(String string) {
        return this.titleVersions.containsKey(string);
    }

    public DockTitleVersion getVersion(String string) {
        return this.titleVersions.get(string);
    }

    public DockTitleVersion getVersion(String string, DockTitleFactory dockTitleFactory) {
        DockTitleVersion dockTitleVersion = this.titleVersions.get(string);
        if (dockTitleVersion == null) {
            dockTitleVersion = new DockTitleVersion(this.controller, string);
            this.titleVersions.put(string, dockTitleVersion);
        }
        if (dockTitleVersion.getFactory(Priority.DEFAULT) == null) {
            dockTitleVersion.setFactory(dockTitleFactory, Priority.DEFAULT);
        }
        return dockTitleVersion;
    }

    public DockTitleVersion registerClient(String string, DockTitleFactory dockTitleFactory) {
        return this.register(string, dockTitleFactory, Priority.CLIENT);
    }

    public DockTitleVersion registerTheme(String string, DockTitleFactory dockTitleFactory) {
        return this.register(string, dockTitleFactory, Priority.THEME);
    }

    public DockTitleVersion registerDefault(String string, DockTitleFactory dockTitleFactory) {
        return this.register(string, dockTitleFactory, Priority.DEFAULT);
    }

    public DockTitleVersion register(String string, DockTitleFactory dockTitleFactory, Priority priority) {
        DockTitleVersion dockTitleVersion = this.titleVersions.get(string);
        if (dockTitleVersion == null) {
            dockTitleVersion = new DockTitleVersion(this.controller, string);
            this.titleVersions.put(string, dockTitleVersion);
        }
        dockTitleVersion.setFactory(dockTitleFactory, priority);
        return dockTitleVersion;
    }

    public void clearThemeFactories() {
        for (DockTitleVersion dockTitleVersion : this.titleVersions.values()) {
            dockTitleVersion.setFactory(null, Priority.THEME);
        }
    }
}

