/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonTrigger;
import bibliothek.util.container.Triple;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDropDownButtonModel
extends BasicButtonModel {
    private boolean overDropDown = false;
    private boolean selectionEnabled = true;
    private BasicDropDownButtonTrigger trigger;

    public BasicDropDownButtonModel(JComponent jComponent, BasicDropDownButtonTrigger basicDropDownButtonTrigger) {
        this(jComponent, basicDropDownButtonTrigger, true);
    }

    public BasicDropDownButtonModel(JComponent jComponent, BasicDropDownButtonTrigger basicDropDownButtonTrigger, boolean bl) {
        super(jComponent, basicDropDownButtonTrigger, bl);
        this.trigger = basicDropDownButtonTrigger;
        if (bl) {
            Listener listener = new Listener();
            jComponent.addMouseMotionListener(listener);
        }
    }

    @Override
    protected List<Triple<KeyStroke, String, Action>> listActions() {
        List<Triple<KeyStroke, String, Action>> list = super.listActions();
        Triple<KeyStroke, String, 1> triple = new Triple<KeyStroke, String, 1>();
        triple.setA(KeyStroke.getKeyStroke(40, 0, true));
        triple.setB("basic_drop_down_model_popup");
        triple.setC(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDropDownButtonModel.this.popupTriggered();
            }
        });
        list.add(triple);
        return list;
    }

    @Override
    protected void setMouseInside(boolean bl) {
        super.setMouseInside(bl);
        if (!bl) {
            this.setMouseOverDropDown(false);
        }
    }

    protected void setMouseOverDropDown(boolean bl) {
        this.overDropDown = bl;
        this.changed();
    }

    public boolean isMouseOverDropDown() {
        return this.overDropDown;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        this.changed();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    @Override
    public Icon getPaintIcon() {
        return super.getPaintIcon(this.isEnabled() && this.isSelectionEnabled());
    }

    protected abstract boolean inDropDownArea(int var1, int var2);

    protected void popupTriggered() {
        this.trigger.popupTriggered();
    }

    private class Listener
    extends MouseMotionAdapter {
        private Listener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = BasicDropDownButtonModel.this.inDropDownArea(mouseEvent.getX(), mouseEvent.getY());
            if (bl != BasicDropDownButtonModel.this.overDropDown) {
                BasicDropDownButtonModel.this.setMouseOverDropDown(bl);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl = BasicDropDownButtonModel.this.inDropDownArea(mouseEvent.getX(), mouseEvent.getY());
            if (bl != BasicDropDownButtonModel.this.overDropDown) {
                BasicDropDownButtonModel.this.setMouseOverDropDown(bl);
            }
        }
    }
}

