/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.LineTabsLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuLineLayout
extends AbstractTabLayoutManager<Layout> {
    @Override
    protected Layout createInfoFor(TabPane tabPane) {
        return new Layout(tabPane);
    }

    @Override
    protected void destroy(Layout layout) {
        layout.destroy();
    }

    @Override
    public Dimension getMinimumSize(TabPane tabPane) {
        Layout layout = (Layout)this.getInfo(tabPane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(TabPane tabPane) {
        Layout layout = (Layout)this.getInfo(tabPane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        return layout.getPreferredSize();
    }

    @Override
    public void layout(TabPane tabPane) {
        Layout layout = (Layout)this.getInfo(tabPane);
        if (layout == null) {
            throw new IllegalArgumentException("unknown pane");
        }
        layout.layout();
    }

    protected Size[] getSizes(LayoutBlock layoutBlock, Size.Type type) {
        if (layoutBlock == null) {
            return new Size[0];
        }
        Size[] sizeArray = layoutBlock.getSizes();
        if (sizeArray == null) {
            return new Size[0];
        }
        return this.getSizes(sizeArray, type);
    }

    protected Size[] getSizes(Size[] sizeArray, Size.Type type) {
        int n = 0;
        for (Size size : sizeArray) {
            if (size.getType() != type) continue;
            ++n;
        }
        Size[] sizeArray2 = new Size[n];
        int n2 = 0;
        for (Size size : sizeArray) {
            if (size.getType() != type) continue;
            sizeArray2[n2++] = size;
        }
        return sizeArray2;
    }

    protected AxisConversion getConversion(TabPane tabPane) {
        return new DefaultAxisConversion(tabPane.getAvailableArea(), tabPane.getTabPlacement());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Layout
    extends AbstractTabLayoutManager.PaneInfo {
        private MenuLayoutBlock menu;
        private LayoutBlock info;
        private LineTabsLayoutBlock tabs;

        public Layout(TabPane tabPane) {
            super(tabPane);
            this.menu = new MenuLayoutBlock();
            this.menu.setMenu(tabPane.createMenu());
            LonelyTabPaneComponent lonelyTabPaneComponent = tabPane.getInfoComponent();
            if (lonelyTabPaneComponent != null) {
                this.info = lonelyTabPaneComponent.toLayoutBlock();
            }
            this.tabs = new LineTabsLayoutBlock();
            this.tabs.setPane(tabPane);
        }

        public Dimension getPreferredSize() {
            List<PaneLayout> list = this.listLayouts();
            Dimension dimension = new Dimension(0, 0);
            if (this.getPane().getTabPlacement().isHorizontal()) {
                for (PaneLayout paneLayout : list) {
                    if (!paneLayout.isPreferred()) continue;
                    Dimension dimension2 = paneLayout.getSize();
                    if (dimension2.width <= dimension.width) continue;
                    dimension = dimension2;
                }
            } else {
                for (PaneLayout paneLayout : list) {
                    if (!paneLayout.isPreferred()) continue;
                    Dimension dimension3 = paneLayout.getSize();
                    if (dimension3.height <= dimension.height) continue;
                    dimension = dimension3;
                }
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            List<PaneLayout> list = this.listLayouts();
            Dimension dimension = null;
            if (this.getPane().getTabPlacement().isHorizontal()) {
                for (PaneLayout paneLayout : list) {
                    Dimension dimension2 = paneLayout.getSize();
                    if (dimension != null && dimension2.width >= dimension.width) continue;
                    dimension = dimension2;
                }
            } else {
                for (PaneLayout paneLayout : list) {
                    Dimension dimension3 = paneLayout.getSize();
                    if (dimension != null && dimension3.height >= dimension.height) continue;
                    dimension = dimension3;
                }
            }
            return dimension;
        }

        public void destroy() {
            this.getPane().destroyMenu(this.menu.getMenu());
        }

        public void layout() {
            AxisConversion axisConversion = MenuLineLayout.this.getConversion(this.getPane());
            List<PaneLayout> list = this.listLayouts();
            Rectangle rectangle = axisConversion.viewToModel(this.getPane().getAvailableArea());
            int n = rectangle.width;
            PaneLayout paneLayout = null;
            int n2 = -1;
            PaneLayout paneLayout2 = null;
            int n3 = -1;
            for (PaneLayout paneLayout3 : list) {
                Dimension dimension = axisConversion.viewToModel(paneLayout3.getSize());
                if (dimension.width <= n) {
                    if (paneLayout3.isPreferred()) {
                        if (paneLayout == null || !paneLayout.isPreferred() || n2 < dimension.width) {
                            n2 = dimension.width;
                            paneLayout = paneLayout3;
                        }
                    } else if (paneLayout == null || !paneLayout.isPreferred() && n2 < dimension.width) {
                        n2 = dimension.width;
                        paneLayout = paneLayout3;
                    }
                }
                if (paneLayout2 != null && dimension.width >= n3) continue;
                paneLayout2 = paneLayout3;
                n3 = dimension.width;
            }
            if (paneLayout != null) {
                paneLayout.apply();
            } else if (paneLayout2 != null) {
                paneLayout2.apply();
            }
        }

        private List<PaneLayout> listLayouts() {
            ArrayList<PaneLayout> arrayList = new ArrayList<PaneLayout>();
            TabPlacement tabPlacement = this.getPane().getTabPlacement();
            this.tabs.setOrientation(tabPlacement);
            LineTabsLayoutBlock.LineSize[] lineSizeArray = this.tabs.getSizes();
            this.menu.setOrientation(tabPlacement);
            Size[] sizeArray = this.menu.getSizes();
            if (this.info != null) {
                Size[] sizeArray2;
                this.info.setOrientation(tabPlacement);
                for (Size size : sizeArray2 = this.info.getSizes()) {
                    this.listLayouts(arrayList, size, sizeArray, lineSizeArray);
                }
            } else {
                this.listLayouts(arrayList, null, sizeArray, lineSizeArray);
            }
            return arrayList;
        }

        private void listLayouts(List<PaneLayout> list, Size size, Size[] sizeArray, LineTabsLayoutBlock.LineSize[] lineSizeArray) {
            for (LineTabsLayoutBlock.LineSize lineSize : lineSizeArray) {
                if (lineSize.isAllTabs()) {
                    this.listLayouts(list, size, (Size)null, lineSize);
                    continue;
                }
                for (Size size2 : sizeArray) {
                    this.listLayouts(list, size, size2, lineSize);
                }
            }
        }

        private void listLayouts(List<PaneLayout> list, Size size, Size size2, LineTabsLayoutBlock.LineSize lineSize) {
            boolean bl;
            boolean bl2 = size != null && size.isMinimum() || size2 != null;
            boolean bl3 = size2 != null && size2.isMinimum();
            boolean bl4 = bl = size2 != null && size2.isMinimum();
            if (bl2 && !lineSize.isMinimum()) {
                return;
            }
            if (bl3 && lineSize.getTabCount() > 1) {
                return;
            }
            if (bl && size != null && !size.isMinimum()) {
                return;
            }
            list.add(new PaneLayout(lineSize, size2, size));
        }

        @Override
        public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
            super.infoComponentChanged(tabPane, lonelyTabPaneComponent, lonelyTabPaneComponent2);
            this.info = lonelyTabPaneComponent2 == null ? null : lonelyTabPaneComponent2.toLayoutBlock();
        }

        private class PaneLayout {
            private Size menuSize;
            private Size infoSize;
            private LineTabsLayoutBlock.LineSize tabSize;

            public PaneLayout(LineTabsLayoutBlock.LineSize lineSize, Size size, Size size2) {
                this.menuSize = size;
                this.tabSize = lineSize;
                this.infoSize = size2;
            }

            public String toString() {
                return this.getClass().getSimpleName() + "@[menu=" + this.menuSize + ", info=" + this.infoSize + ", tabs=" + this.tabSize + "]";
            }

            public boolean isPreferred() {
                if (!this.tabSize.isPreferred() || !this.tabSize.isAllTabs()) {
                    return false;
                }
                if (this.menuSize != null) {
                    return false;
                }
                return this.tabSize == null || this.tabSize.isPreferred();
            }

            public Dimension getSize() {
                int n = this.tabSize.getWidth();
                int n2 = this.tabSize.getHeight();
                if (Layout.this.getPane().getTabPlacement().isHorizontal()) {
                    if (this.menuSize != null) {
                        n += this.menuSize.getWidth();
                        n2 = Math.max(n2, this.menuSize.getHeight());
                    }
                    if (this.infoSize != null) {
                        n += this.infoSize.getWidth();
                        n2 = Math.max(n2, this.infoSize.getHeight());
                    }
                } else {
                    if (this.menuSize != null) {
                        n = Math.max(n, this.menuSize.getWidth());
                        n2 += this.menuSize.getHeight();
                    }
                    if (this.infoSize != null) {
                        n = Math.max(n, this.infoSize.getWidth());
                        n2 += this.infoSize.getHeight();
                    }
                }
                return new Dimension(n, n2);
            }

            /*
             * WARNING - void declaration
             */
            public void apply() {
                void var8_27;
                int n;
                void var5_14;
                int n2;
                Cloneable cloneable;
                TabPane tabPane = Layout.this.getPane();
                AxisConversion axisConversion = MenuLineLayout.this.getConversion(tabPane);
                TabPlacement tabPlacement = tabPane.getTabPlacement();
                Layout.this.tabs.setLayout(this.tabSize);
                if (this.infoSize != null && Layout.this.info != null) {
                    Layout.this.info.setLayout(this.infoSize);
                }
                if (this.menuSize == null) {
                    Layout.this.menu.getMenu().setPaneVisible(false);
                } else {
                    Layout.this.menu.getMenu().setPaneVisible(true);
                    Layout.this.menu.setLayout(this.menuSize);
                }
                if (this.menuSize != null) {
                    cloneable = new HashSet();
                    for (Dockable dockable : tabPane.getDockables()) {
                        cloneable.add(dockable);
                    }
                    Tab[] n3 = this.tabSize.getTabs();
                    int n4 = n3.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        Tab tab = n3[n2];
                        cloneable.remove(tab.getDockable());
                    }
                    TabMenu tabMenu = Layout.this.menu.getMenu();
                    Iterator iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        Dockable dockable = (Dockable)iterator.next();
                        tabPane.putInMenu(tabMenu, dockable);
                    }
                }
                cloneable = axisConversion.viewToModel(tabPane.getAvailableArea());
                if (tabPlacement.isHorizontal()) {
                    int n5;
                    int n6 = this.tabSize.getHeight();
                    if (this.infoSize != null) {
                        n5 = Math.max(n6, this.infoSize.getHeight());
                    }
                    if (this.menuSize != null) {
                        int n7 = Math.max(n5, this.menuSize.getHeight());
                    }
                } else {
                    int n8;
                    int n9 = this.tabSize.getWidth();
                    if (this.infoSize != null) {
                        n8 = Math.max(n9, this.infoSize.getWidth());
                    }
                    if (this.menuSize != null) {
                        int n10 = Math.max(n8, this.menuSize.getWidth());
                    }
                }
                int n11 = Math.max(0, Math.min((int)var5_14, ((Rectangle)cloneable).height / 2));
                tabPane.setSelectedBounds(axisConversion.modelToView(new Rectangle(((Rectangle)cloneable).x, ((Rectangle)cloneable).y + n11, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height - n11)));
                boolean bl = false;
                int n12 = 0;
                if (tabPlacement.isHorizontal()) {
                    n = n2 = this.tabSize.getWidth();
                    if (this.infoSize != null) {
                        n12 = this.infoSize.getWidth();
                        n += n12;
                    }
                    if (this.menuSize != null) {
                        int n13 = this.menuSize.getWidth();
                        n += n13;
                    }
                } else {
                    n = n2 = this.tabSize.getHeight();
                    if (this.infoSize != null) {
                        n12 = this.infoSize.getHeight();
                        n += n12;
                    }
                    if (this.menuSize != null) {
                        int n14 = this.menuSize.getHeight();
                        n += n14;
                    }
                }
                if (((Rectangle)cloneable).width >= n) {
                    Rectangle rectangle;
                    Rectangle rectangle2 = new Rectangle(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width - n + n2, n11);
                    rectangle2 = axisConversion.modelToView(rectangle2);
                    Layout.this.tabs.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (this.menuSize != null) {
                        rectangle = new Rectangle(((Rectangle)cloneable).x + n2, ((Rectangle)cloneable).y, (int)var8_27, n11);
                        rectangle = axisConversion.modelToView(rectangle);
                        Layout.this.menu.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    if (this.infoSize != null && Layout.this.info != null) {
                        rectangle = new Rectangle(((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n12, ((Rectangle)cloneable).y, n12, n11);
                        rectangle = axisConversion.modelToView(rectangle);
                        Layout.this.info.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    Rectangle rectangle;
                    double d = (double)n / (double)((Rectangle)cloneable).width;
                    int n15 = ((Rectangle)cloneable).x;
                    int n16 = (int)(d * (double)n2);
                    Rectangle rectangle3 = new Rectangle(n15, ((Rectangle)cloneable).y, n16, n11);
                    rectangle3 = axisConversion.modelToView(rectangle3);
                    Layout.this.tabs.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    n15 += n16;
                    if (this.menuSize != null) {
                        n16 = (int)(d * (double)var8_27);
                        rectangle = new Rectangle(n15, ((Rectangle)cloneable).y, n16, n11);
                        rectangle = axisConversion.modelToView(rectangle);
                        Layout.this.menu.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        n15 += n16;
                    }
                    if (this.infoSize != null) {
                        n16 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n15;
                        rectangle = new Rectangle(n15, ((Rectangle)cloneable).y, n16, n11);
                        rectangle = axisConversion.modelToView(rectangle);
                        Layout.this.info.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
            }
        }
    }
}

