/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitDockPathProperty
extends AbstractDockableProperty
implements Iterable<Node> {
    private List<Node> nodes = new LinkedList<Node>();
    private long leafId = -1L;

    @Override
    public DockableProperty copy() {
        SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
        for (Node node : this.nodes) {
            splitDockPathProperty.add(node.getLocation(), node.getSize(), node.getId());
        }
        splitDockPathProperty.setLeafId(this.getLeafId());
        this.copy(splitDockPathProperty);
        return splitDockPathProperty;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.nodes.size();
    }

    public Node getNode(int n) {
        return this.nodes.get(n);
    }

    public void setLeafId(long l) {
        this.leafId = l;
    }

    public long getLeafId() {
        return this.leafId;
    }

    public Node getLastNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public SplitDockProperty toLocation() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    d3 *= node.getSize();
                    break;
                }
                case RIGHT: {
                    d = d + d3 - d3 * node.getSize();
                    d3 *= node.getSize();
                    break;
                }
                case TOP: {
                    d4 *= node.getSize();
                    break;
                }
                case BOTTOM: {
                    d2 = d2 + d4 - d4 * node.getSize();
                    d4 *= node.getSize();
                }
            }
        }
        SplitDockProperty splitDockProperty = new SplitDockProperty(d, d2, d3, d4);
        splitDockProperty.setSuccessor(this.getSuccessor());
        return splitDockProperty;
    }

    public SplitDockProperty toLocation(SplitNode splitNode) {
        SplitDockProperty splitDockProperty;
        if (splitNode == null || splitNode.getId() == -1L) {
            return this.toLocation();
        }
        long l = splitNode.getId();
        if (this.getLeafId() == l) {
            splitDockProperty = new SplitDockProperty(splitNode.getX(), splitNode.getY(), splitNode.getWidth(), splitNode.getHeight());
        } else {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 1.0;
            double d4 = 1.0;
            for (Node node : this.nodes) {
                if (node.getId() == l) {
                    d = splitNode.getX();
                    d2 = splitNode.getY();
                    d3 = splitNode.getWidth();
                    d4 = splitNode.getHeight();
                }
                switch (node.getLocation()) {
                    case LEFT: {
                        d3 *= node.getSize();
                        break;
                    }
                    case RIGHT: {
                        d = d + d3 - d3 * node.getSize();
                        d3 *= node.getSize();
                        break;
                    }
                    case TOP: {
                        d4 *= node.getSize();
                        break;
                    }
                    case BOTTOM: {
                        d2 = d2 + d4 - d4 * node.getSize();
                        d4 *= node.getSize();
                    }
                }
            }
            splitDockProperty = new SplitDockProperty(d, d2, d3, d4);
        }
        splitDockProperty.setSuccessor(this.getSuccessor());
        return splitDockProperty;
    }

    public void add(Location location, double d, long l) {
        this.insert(location, d, this.nodes.size(), l);
    }

    public void insert(Location location, double d, int n, long l) {
        if (location == null) {
            throw new NullPointerException("location must not be null");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("size must be in the range 0.0 to 1.0");
        }
        this.nodes.add(n, new Node(location, d, l));
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPathProperty";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.nodes.size());
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    dataOutputStream.writeByte(0);
                    break;
                }
                case RIGHT: {
                    dataOutputStream.writeByte(1);
                    break;
                }
                case TOP: {
                    dataOutputStream.writeByte(2);
                    break;
                }
                case BOTTOM: {
                    dataOutputStream.writeByte(3);
                }
            }
            dataOutputStream.writeDouble(node.getSize());
            dataOutputStream.writeLong(node.getId());
        }
        dataOutputStream.writeLong(this.leafId);
    }

    @Override
    public void store(XElement xElement) {
        for (Node node : this.nodes) {
            XElement xElement2 = xElement.addElement("node");
            xElement2.addString("location", node.getLocation().name());
            xElement2.addDouble("size", node.getSize());
            if (node.getId() < 0L) continue;
            xElement2.addLong("id", node.getId());
        }
        xElement.addElement("leaf").addLong("id", this.leafId);
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        this.nodes.clear();
        int n = dataInputStream.readInt();
        while (n > 0) {
            --n;
            Location location = null;
            switch (dataInputStream.readByte()) {
                case 0: {
                    location = Location.LEFT;
                    break;
                }
                case 1: {
                    location = Location.RIGHT;
                    break;
                }
                case 2: {
                    location = Location.TOP;
                    break;
                }
                case 3: {
                    location = Location.BOTTOM;
                }
            }
            double d = dataInputStream.readDouble();
            long l = -1L;
            if (bl) {
                l = dataInputStream.readLong();
            }
            this.nodes.add(new Node(location, d, l));
        }
        this.leafId = bl ? dataInputStream.readLong() : -1L;
    }

    @Override
    public void load(XElement xElement) {
        this.nodes.clear();
        for (XElement xElement2 : xElement.getElements("node")) {
            Location location = Location.valueOf(xElement2.getString("location"));
            double d = xElement2.getDouble("size");
            long l = -1L;
            if (xElement2.attributeExists("id")) {
                l = xElement2.getLong("id");
            }
            this.nodes.add(new Node(location, d, l));
        }
        XElement xElement3 = xElement.getElement("leaf");
        this.leafId = xElement3 != null ? xElement3.getLong("id") : -1L;
    }

    public String toString() {
        return this.getClass().getName() + "[nodes=" + this.nodes + ", leaf=" + this.leafId + "]";
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.nodes == null ? 0 : ((Object)this.nodes).hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SplitDockPathProperty)) {
            return false;
        }
        SplitDockPathProperty splitDockPathProperty = (SplitDockPathProperty)object;
        return !(this.nodes == null ? splitDockPathProperty.nodes != null : !((Object)this.nodes).equals(splitDockPathProperty.nodes));
    }

    public static class Node {
        private double size;
        private Location location;
        private long id;

        public Node(Location location, double d, long l) {
            this.location = location;
            this.size = d;
            this.id = l;
        }

        public double getSize() {
            return this.size;
        }

        public Location getLocation() {
            return this.location;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return "[size=" + this.size + ", location=" + (Object)((Object)this.location) + ", id=" + this.id + "]";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.location == null ? 0 : this.location.hashCode());
            long l = Double.doubleToLongBits(this.size);
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Node)) {
                return false;
            }
            Node node = (Node)object;
            if (this.location == null ? node.location != null : !this.location.equals((Object)node.location)) {
                return false;
            }
            return Double.doubleToLongBits(this.size) == Double.doubleToLongBits(node.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

