/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.screen.DisplayerScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractScreenDockWindow
extends DisplayerScreenDockWindow {
    private Component window;
    private DockableDisplayer displayer;
    private OverpaintablePanel content;
    private boolean painting = false;
    private Icon titleIcon = null;
    private String titleText = null;
    private DockableListener listener = new DockableAdapter(){

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            AbstractScreenDockWindow.this.updateTitleIcon();
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            AbstractScreenDockWindow.this.updateTitleText();
        }
    };
    private ScreenDockWindowListener windowListener = new ScreenDockWindowListener(){
        private boolean remembered = false;

        public void visibilityChanged(ScreenDockWindow screenDockWindow) {
            if (AbstractScreenDockWindow.this.isFullscreen() != this.remembered) {
                AbstractScreenDockWindow.this.fireFullscreenChanged();
            }
        }

        public void shapeChanged(ScreenDockWindow screenDockWindow) {
            if (AbstractScreenDockWindow.this.isFullscreen() != this.remembered) {
                AbstractScreenDockWindow.this.fireFullscreenChanged();
            }
        }

        public void fullscreenStateChanged(ScreenDockWindow screenDockWindow) {
            this.remembered = AbstractScreenDockWindow.this.isFullscreen();
        }
    };

    protected AbstractScreenDockWindow(ScreenDockStation screenDockStation) {
        super(screenDockStation);
    }

    public AbstractScreenDockWindow(ScreenDockStation screenDockStation, Component component, Container container, boolean bl) {
        super(screenDockStation);
        this.init(component, container, bl);
    }

    protected void init(Component component, Container container, boolean bl) {
        if (component == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("contentParent must not be null");
        }
        this.window = component;
        this.content = this.createContent();
        container.setLayout(new GridLayout(1, 1));
        container.add(this.content);
        Container container2 = this.getDisplayerParent();
        container2.setLayout(new GridLayout(1, 1));
        if (bl) {
            if (container2 instanceof JComponent) {
                ((JComponent)container2).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            }
            Listener listener = new Listener();
            container2.addMouseListener(listener);
            container2.addMouseMotionListener(listener);
        }
        component.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AbstractScreenDockWindow.this.fireShapeChanged();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                AbstractScreenDockWindow.this.fireShapeChanged();
            }
        });
        this.addScreenDockWindowListener(this.windowListener);
    }

    protected Component getWindowComponent() {
        return this.window;
    }

    public void setDockable(Dockable dockable) {
        Dockable dockable2 = this.getDockable();
        if (dockable2 != null) {
            dockable2.removeDockableListener(this.listener);
        }
        super.setDockable(dockable);
        if (dockable != null) {
            dockable.addDockableListener(this.listener);
        }
        this.updateTitleIcon();
        this.updateTitleText();
    }

    protected void showDisplayer(DockableDisplayer dockableDisplayer) {
        if (this.displayer != dockableDisplayer) {
            if (this.displayer != null) {
                this.getDisplayerParent().remove(this.displayer.getComponent());
            }
            this.displayer = dockableDisplayer;
            if (dockableDisplayer != null) {
                this.getDisplayerParent().add(dockableDisplayer.getComponent());
            }
        }
        this.validate();
    }

    public void setTitleIcon(Icon icon) {
        this.titleIcon = icon;
        this.updateTitleIcon();
    }

    protected Icon getTitleIcon() {
        if (this.titleIcon != null) {
            return this.titleIcon;
        }
        Dockable dockable = this.getDockable();
        if (dockable == null) {
            return null;
        }
        return dockable.getTitleIcon();
    }

    protected void updateTitleIcon() {
    }

    public void setTitleText(String string) {
        this.titleText = string;
        this.updateTitleText();
    }

    protected String getTitleText() {
        if (this.titleText != null) {
            return this.titleText;
        }
        Dockable dockable = this.getDockable();
        if (dockable == null) {
            return null;
        }
        return dockable.getTitleText();
    }

    protected void updateTitleText() {
    }

    public Rectangle getWindowBounds() {
        return this.window.getBounds();
    }

    public void setPaintCombining(boolean bl) {
        this.painting = bl;
        this.window.repaint();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            this.window.setVisible(bl);
            this.fireVisibilityChanged();
        }
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public void setWindowBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getStation().getBoundaryRestriction().check(this, rectangle);
        if (rectangle2 != null) {
            this.window.setBounds(rectangle2);
        } else {
            this.window.setBounds(rectangle);
        }
        this.invalidate();
        this.validate();
    }

    public void checkWindowBounds() {
        Rectangle rectangle = this.getStation().getBoundaryRestriction().check(this);
        if (rectangle != null) {
            this.window.setBounds(rectangle);
        }
    }

    public void invalidate() {
        this.window.invalidate();
    }

    public void validate() {
        this.window.validate();
    }

    protected void setCursor(Cursor cursor) {
        this.window.setCursor(cursor);
    }

    public Insets getDockableInsets() {
        Container container = this.getDisplayerParent();
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(container, point, this.window);
        insets.left += point.x;
        insets.top += point.y;
        insets.right += this.window.getWidth() - container.getWidth() - point.x;
        insets.bottom += this.window.getHeight() - container.getHeight() - point.y;
        if (this.displayer == null) {
            return insets;
        }
        Insets insets2 = this.displayer.getDockableInsets();
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        insets.left += insets2.left;
        insets.right += insets2.right;
        return insets;
    }

    protected OverpaintablePanel createContent() {
        OverpaintablePanel overpaintablePanel = new OverpaintablePanel(){

            protected void paintOverlay(Graphics graphics) {
                if (AbstractScreenDockWindow.this.painting) {
                    ScreenDockStation screenDockStation = AbstractScreenDockWindow.this.getStation();
                    StationPaintWrapper stationPaintWrapper = screenDockStation.getPaint();
                    Insets insets = this.getInsets();
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    Rectangle rectangle2 = new Rectangle(2 * insets.left, 2 * insets.top, this.getWidth() - 2 * (insets.left + insets.right), this.getHeight() - 2 * (insets.top + insets.bottom));
                    stationPaintWrapper.drawInsertion(graphics, screenDockStation, rectangle, rectangle2);
                }
            }
        };
        return overpaintablePanel;
    }

    protected Container getDisplayerParent() {
        return this.content.getContentPane();
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private boolean pressed = false;
        private Position position = Position.NOTHING;
        private Point start;
        private Rectangle bounds;

        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent);
            if (!this.pressed && mouseEvent.getButton() == 1) {
                this.pressed = true;
                this.start = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(this.start, mouseEvent.getComponent());
                this.bounds = AbstractScreenDockWindow.this.getWindowBounds();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pressed && mouseEvent.getButton() == 1) {
                this.pressed = false;
                this.updateCursor(mouseEvent);
                AbstractScreenDockWindow.this.checkWindowBounds();
                AbstractScreenDockWindow.this.invalidate();
                AbstractScreenDockWindow.this.validate();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.pressed && mouseEvent.getButton() == 0) {
                this.updateCursor(mouseEvent);
                this.position = Position.NOTHING;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.pressed && mouseEvent.getButton() == 0) {
                AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                this.position = Position.NOTHING;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressed) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                int n = point.x - this.start.x;
                int n2 = point.y - this.start.y;
                Rectangle rectangle = new Rectangle(this.bounds);
                int n3 = 25;
                if (this.position == Position.N || this.position == Position.NE || this.position == Position.NW) {
                    rectangle.height -= n2;
                    rectangle.y += n2;
                    if (rectangle.height < n3) {
                        rectangle.y -= n3 - rectangle.height;
                        rectangle.height = n3;
                    }
                }
                if (this.position == Position.E || this.position == Position.NE || this.position == Position.SE) {
                    rectangle.width += n;
                    if (rectangle.width < n3) {
                        rectangle.width = n3;
                    }
                }
                if (this.position == Position.S || this.position == Position.SE || this.position == Position.SW) {
                    rectangle.height += n2;
                    if (rectangle.height < n3) {
                        rectangle.height = n3;
                    }
                }
                if (this.position == Position.W || this.position == Position.SW || this.position == Position.NW) {
                    rectangle.width -= n;
                    rectangle.x += n;
                    if (rectangle.width < n3) {
                        rectangle.x -= n3 - rectangle.width;
                        rectangle.width = n3;
                    }
                }
                if (this.position == Position.MOVE) {
                    rectangle.x += n;
                    rectangle.y += n2;
                }
                AbstractScreenDockWindow.this.setWindowBounds(rectangle);
                AbstractScreenDockWindow.this.invalidate();
                AbstractScreenDockWindow.this.validate();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.pressed && mouseEvent.getButton() == 0) {
                this.updateCursor(mouseEvent);
            }
        }

        private void updateCursor(MouseEvent mouseEvent) {
            boolean bl;
            Container container = AbstractScreenDockWindow.this.getDisplayerParent();
            Insets insets = container.getInsets();
            boolean bl2 = bl = mouseEvent.getComponent() == container && mouseEvent.getY() <= insets.top || mouseEvent.getY() >= container.getHeight() - insets.bottom || mouseEvent.getX() <= insets.left || mouseEvent.getX() >= container.getWidth() - insets.right;
            if (bl) {
                boolean bl3;
                boolean bl4 = mouseEvent.getY() <= insets.top * 5;
                boolean bl5 = mouseEvent.getX() <= insets.left * 5;
                boolean bl6 = mouseEvent.getY() >= container.getHeight() - insets.bottom * 5;
                boolean bl7 = bl3 = mouseEvent.getX() >= container.getWidth() - insets.right * 5;
                if (bl4 && bl5) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(6));
                    this.position = Position.NW;
                } else if (bl4 && bl3) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(7));
                    this.position = Position.NE;
                } else if (bl6 && bl3) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(5));
                    this.position = Position.SE;
                } else if (bl6 && bl5) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(4));
                    this.position = Position.SW;
                } else if (bl4) {
                    int n = container.getWidth();
                    if (mouseEvent.getX() > n / 3 && mouseEvent.getX() < n / 3 * 2) {
                        AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(13));
                        this.position = Position.MOVE;
                    } else {
                        AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(8));
                        this.position = Position.N;
                    }
                } else if (bl6) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(9));
                    this.position = Position.S;
                } else if (bl5) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(10));
                    this.position = Position.W;
                } else if (bl3) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(11));
                    this.position = Position.E;
                } else {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                    this.position = Position.NOTHING;
                }
            } else {
                AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                this.position = Position.NOTHING;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        N,
        E,
        S,
        W,
        NE,
        SW,
        NW,
        SE,
        MOVE,
        NOTHING;

    }
}

