/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.layout.BackupFactoryData;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteringDockFactory<D extends Dockable, L>
implements DockFactory<D, BackupFactoryData<L>> {
    private DockFrontend frontend;
    private DockFactory<D, L> factory;

    public RegisteringDockFactory(DockFrontend dockFrontend, DockFactory<D, L> dockFactory) {
        this.frontend = dockFrontend;
        this.factory = dockFactory;
    }

    @Override
    public String getID() {
        return this.factory.getID();
    }

    @Override
    public void estimateLocations(BackupFactoryData<L> backupFactoryData, LocationEstimationMap locationEstimationMap) {
        this.factory.estimateLocations(backupFactoryData.getData(), locationEstimationMap);
    }

    @Override
    public BackupFactoryData<L> getLayout(D d, Map<Dockable, Integer> map) {
        return new BackupFactoryData(null, this.factory.getLayout(d, map));
    }

    @Override
    public D layout(BackupFactoryData<L> backupFactoryData, Map<Integer, Dockable> map) {
        String string;
        Dockable dockable = (Dockable)this.factory.layout(backupFactoryData.getData());
        if (dockable != null && (string = backupFactoryData.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(string = string.substring("dockable".length())) == null) {
            this.frontend.addDockable(string, dockable);
        }
        return (D)dockable;
    }

    @Override
    public D layout(BackupFactoryData<L> backupFactoryData) {
        String string;
        Dockable dockable = (Dockable)this.factory.layout(backupFactoryData.getData());
        if (dockable != null && (string = backupFactoryData.getIdentifier()).startsWith("dockable") && this.frontend.getDockable(string = string.substring("dockable".length())) == null) {
            this.frontend.addDockable(string, dockable);
        }
        return (D)dockable;
    }

    @Override
    public BackupFactoryData<L> read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        return new BackupFactoryData(null, this.factory.read(dataInputStream, placeholderStrategy));
    }

    @Override
    public BackupFactoryData<L> read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        return new BackupFactoryData(null, this.factory.read(xElement, placeholderStrategy));
    }

    @Override
    public void setLayout(D d, BackupFactoryData<L> backupFactoryData, Map<Integer, Dockable> map) {
        this.factory.setLayout(d, backupFactoryData.getData(), map);
    }

    @Override
    public void setLayout(D d, BackupFactoryData<L> backupFactoryData) {
        this.factory.setLayout(d, backupFactoryData.getData());
    }

    @Override
    public void write(BackupFactoryData<L> backupFactoryData, DataOutputStream dataOutputStream) throws IOException {
        this.factory.write(backupFactoryData.getData(), dataOutputStream);
    }

    @Override
    public void write(BackupFactoryData<L> backupFactoryData, XElement xElement) {
        this.factory.write(backupFactoryData.getData(), xElement);
    }
}

