/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.LocatedListenerList;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.MouseInputAdapter;

public class DoubleClickController {
    private LocatedListenerList<DoubleClickListener> observers = new LocatedListenerList();
    private Map<DockElementRepresentative, GlobalDoubleClickListener> listeners = new HashMap<DockElementRepresentative, GlobalDoubleClickListener>();

    public DoubleClickController(ControllerSetupCollection controllerSetupCollection) {
        controllerSetupCollection.add(new ControllerSetupListener(){

            public void done(DockController dockController) {
                dockController.addRepresentativeListener(new DockControllerRepresentativeListener(){

                    public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
                        Dockable dockable = dockElementRepresentative.getElement().asDockable();
                        if (dockable != null) {
                            GlobalDoubleClickListener globalDoubleClickListener = new GlobalDoubleClickListener(dockable);
                            dockElementRepresentative.addMouseInputListener(globalDoubleClickListener);
                            DoubleClickController.this.listeners.put(dockElementRepresentative, globalDoubleClickListener);
                        }
                    }

                    public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
                        GlobalDoubleClickListener globalDoubleClickListener;
                        Dockable dockable = dockElementRepresentative.getElement().asDockable();
                        if (dockable != null && (globalDoubleClickListener = (GlobalDoubleClickListener)DoubleClickController.this.listeners.remove(dockElementRepresentative)) != null) {
                            dockElementRepresentative.removeMouseInputListener(globalDoubleClickListener);
                        }
                    }
                });
            }
        });
    }

    public void addListener(DoubleClickListener doubleClickListener) {
        this.observers.addListener(doubleClickListener);
    }

    public void removeListener(DoubleClickListener doubleClickListener) {
        this.observers.removeListener(doubleClickListener);
    }

    public void send(Dockable dockable, MouseEvent mouseEvent) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (mouseEvent == null) {
            throw new NullPointerException("event must not be null");
        }
        if (mouseEvent.getClickCount() != 2) {
            throw new IllegalArgumentException("click count must be equal to 2");
        }
        List<DoubleClickListener> list = this.observers.affected(dockable);
        for (DoubleClickListener doubleClickListener : list) {
            if (!doubleClickListener.process(dockable, mouseEvent)) continue;
            mouseEvent.consume();
            break;
        }
    }

    protected class GlobalDoubleClickListener
    extends MouseInputAdapter {
        private Dockable dockable;

        public GlobalDoubleClickListener(Dockable dockable) {
            this.dockable = dockable;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2) {
                DoubleClickController.this.send(this.dockable, mouseEvent);
            }
        }
    }
}

