/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.themes.basic.BasicButtonDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Container;

public class SmoothDefaultButtonTitle
extends BasicButtonDockTitle {
    private final int ACTIVE_STATE = 0;
    private final int SELECTED_STATE = 1;
    private final int INACTIVE_STATE = 2;
    private int[] current;
    private SmoothChanger changer = new SmoothChanger(3){

        protected int destination() {
            if (SmoothDefaultButtonTitle.this.isActive()) {
                return 0;
            }
            if (SmoothDefaultButtonTitle.this.isSelected()) {
                return 1;
            }
            return 2;
        }

        protected void repaint(int[] nArray) {
            SmoothDefaultButtonTitle.access$002(SmoothDefaultButtonTitle.this, (int[])nArray.clone());
            SmoothDefaultButtonTitle.this.updateColors();
        }
    };

    public SmoothDefaultButtonTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion);
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    public void changed(DockTitleEvent dockTitleEvent) {
        super.changed(dockTitleEvent);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    protected void updateColors() {
        this.updateForegroundColor();
        this.updateBackgroundColor();
    }

    protected void updateForegroundColor() {
        if (this.changer != null && this.changer.isRunning() && this.current != null) {
            this.setForeground(this.triColor(this.foreground(this.getActiveTextColor()), this.foreground(this.getSelectedTextColor()), this.foreground(this.getInactiveTextColor())));
        } else if (this.isActive()) {
            this.setForeground(this.getActiveTextColor());
        } else if (this.isSelected()) {
            this.setForeground(this.getSelectedTextColor());
        } else {
            this.setForeground(this.getInactiveTextColor());
        }
    }

    protected void updateBackgroundColor() {
        if (this.changer != null && this.changer.isRunning() && this.current != null) {
            this.setBackground(this.triColor(this.background(this.getActiveColor()), this.background(this.getSelectedColor()), this.background(this.getInactiveColor())));
        } else if (this.isActive()) {
            this.setBackground(this.getActiveColor());
        } else if (this.isSelected()) {
            this.setBackground(this.getSelectedColor());
        } else {
            this.setBackground(this.getInactiveColor());
        }
    }

    private Color triColor(Color color, Color color2, Color color3) {
        int n = 0;
        for (int n2 : this.current) {
            n += n2;
        }
        if (n == 0) {
            return Color.BLACK;
        }
        double d = (double)this.current[0] / (double)n;
        double d2 = (double)this.current[1] / (double)n;
        double d3 = (double)this.current[2] / (double)n;
        double d4 = d * (double)color.getRed() + d2 * (double)color2.getRed() + d3 * (double)color3.getRed();
        double d5 = d * (double)color.getGreen() + d2 * (double)color2.getGreen() + d3 * (double)color3.getGreen();
        double d6 = d * (double)color.getBlue() + d2 * (double)color2.getBlue() + d3 * (double)color3.getBlue();
        return new Color(Math.max(0, Math.min(255, (int)d4)), Math.max(0, Math.min(255, (int)d5)), Math.max(0, Math.min(255, (int)d6)));
    }

    private Color foreground(Color color) {
        if (color != null) {
            return color;
        }
        Container container = this.getParent();
        if (container == null) {
            return Color.BLACK;
        }
        color = container.getForeground();
        if (color != null) {
            return color;
        }
        return Color.BLACK;
    }

    private Color background(Color color) {
        if (color != null) {
            return color;
        }
        Container container = this.getParent();
        if (container == null) {
            return Color.WHITE;
        }
        color = container.getBackground();
        if (color != null) {
            return color;
        }
        return Color.WHITE;
    }

    static /* synthetic */ int[] access$002(SmoothDefaultButtonTitle smoothDefaultButtonTitle, int[] nArray) {
        smoothDefaultButtonTitle.current = nArray;
        return nArray;
    }
}

