/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.preferences;

import bibliothek.extension.gui.dock.preference.DefaultPreference;
import bibliothek.extension.gui.dock.preference.preferences.choice.DefaultChoice;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceDockPropertyPreference<V>
extends DefaultPreference<String> {
    private DockProperties properties;
    private PropertyKey<V> key;
    private DefaultChoice<V> choice;

    public ChoiceDockPropertyPreference(DockProperties dockProperties, PropertyKey<V> propertyKey, Path path, DefaultChoice<V> defaultChoice) {
        super(Path.TYPE_STRING_CHOICE_PATH, path);
        this.properties = dockProperties;
        this.choice = defaultChoice;
        this.key = propertyKey;
        this.setValueInfo(defaultChoice);
    }

    @Override
    public void write() {
        this.properties.setOrRemove(this.key, this.choice.identifierToValue((String)this.getValue()), Priority.CLIENT);
    }

    @Override
    public void read() {
        V v = this.properties.get(this.key, Priority.CLIENT);
        if (v == null) {
            this.setValue(this.choice.getDefaultChoice());
        } else {
            String string = this.choice.valueToIdentifier(v);
            if (string != null || this.choice.isNullEntryAllowed()) {
                this.setValue(string);
            }
        }
    }
}

