/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPreferenceModel
implements PreferenceModel {
    private List<PreferenceModelListener> listeners = new ArrayList<PreferenceModelListener>();

    public void read() {
    }

    public void write() {
    }

    public boolean isEnabled(int n, PreferenceOperation preferenceOperation) {
        return false;
    }

    public PreferenceOperation[] getOperations(int n) {
        return null;
    }

    public void doOperation(int n, PreferenceOperation preferenceOperation) {
    }

    public void addPreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        if (preferenceModelListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(preferenceModelListener);
    }

    public void removePreferenceModelListener(PreferenceModelListener preferenceModelListener) {
        this.listeners.remove(preferenceModelListener);
    }

    protected PreferenceModelListener[] listeners() {
        return this.listeners.toArray(new PreferenceModelListener[this.listeners.size()]);
    }

    protected boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    protected void firePreferenceAdded(int n, int n2) {
        for (PreferenceModelListener preferenceModelListener : this.listeners) {
            preferenceModelListener.preferenceAdded(this, n, n2);
        }
    }

    protected void firePreferenceRemoved(int n, int n2) {
        for (PreferenceModelListener preferenceModelListener : this.listeners) {
            preferenceModelListener.preferenceRemoved(this, n, n2);
        }
    }

    protected void firePreferenceChanged(int n, int n2) {
        for (PreferenceModelListener preferenceModelListener : this.listeners) {
            preferenceModelListener.preferenceChanged(this, n, n2);
        }
    }

    public String getDescription(int n) {
        return null;
    }

    public boolean isNatural(int n) {
        return false;
    }

    public void setValueNatural(int n) {
    }
}

