% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSPC.R
\name{loadAllSPCFiles}
\alias{loadAllSPCFiles}
\title{Load all or a selection of SPC files from a given directory.}
\usage{
loadAllSPCFiles(directoryFiles, selectedFiles = NULL)
}
\arguments{
\item{directoryFiles}{Character vector indicating the directory from which the files needs to be downloaded. Note that files with an other extension than '.spc' can be stored in this directory.}

\item{selectedFiles}{Character vector listing which files of the chosen directory (as expressed by the 'directoryFiles' argument) should be processed. This argument is used when one wants to process a subset of the spc files of the selected directory only. Note that one should add the complete file name to this list, including the file extension! This is an optional argument with as default value NULL, meaning that by default all files of the selected directory are considered.}
}
\value{
A list is returned of which each element contains a processed SPC file
}
\description{
This function automatically recognizes all the files bearing an '.spc' extension and returns a list in which each element corresponds to a different xml file.
}
