% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/CUSUM.R, R/EWMA.R, R/shewhart.R
\docType{methods}
\name{getq}
\alias{getq}
\alias{getq,SPCCUSUM-method}
\alias{getq,SPCEWMA-method}
\alias{getq,SPCShew-method}
\title{Returns a List to Compute Properties of a chart}
\usage{
getq(chart, property, params)

\S4method{getq}{SPCCUSUM}(chart, property, params)

\S4method{getq}{SPCEWMA}(chart, property, params)

\S4method{getq}{SPCShew}(chart, property, params)
}
\arguments{
\item{chart}{the chart to be used.}

\item{property}{the name of the property.}

\item{params}{additional parameters needed for the computations.}
}
\value{
A list with the elements \code{q}, \code{trafo}, \code{lowerconf}, \code{format}.
\itemize{
\item{\code{q(P,xi)}: The transformed property of interest. To improve the bootstrap a log transform is used for \code{calARL},\code{calhitprob} and \code{ARL}, and a logit transform for \code{hitprob}. This function depends on the distribution of updates \code{P} and the chart parameters \code{xi}.} 
\item{\code{trafo(x)}: The inverse of the transformation of the property used in the bootstrap. Needed to back-transform the result to the correct scale. }
\item{\code{lowerconf}: Logical value. TRUE if a lower confidence interval should be reported, FALSE otherwise. Default is TRUE for properties \code{calARL},  \code{calhitprob} and \code{hitprob} and FALSE for \code{ARL}. }
\item{\code{format(res)}: Output summary given as a text string. }
}
}
\description{
Returns functions to compute desired properties of a given
control chart.
}
\section{Methods (by class)}{
\itemize{
\item \code{SPCCUSUM}: Implements the properties \code{ARL},
\code{calARL}, \code{hitprob} and \code{calhitprob}.

\item \code{SPCEWMA}: Implements the properties \code{ARL},
\code{calARL}, \code{hitprob} and \code{calhitprob}.

\item \code{SPCShew}: Implements the properties \code{ARL},
\code{calARL}, \code{hitprob} and \code{calhitprob}.
}}

