\name{rSwitzerlpp}
\alias{rSwitzerlpp}
\title{
  Switzer-type Point Process on Linear Network
}
\description{
  Generate a realisation of the Switzer-type point process
  on a linear network.
}
\usage{
rSwitzerlpp(L, lambdacut, rintens = rexp, \dots,
         cuts=c("points", "lines"))
}
\arguments{
  \item{L}{
    Linear network (object of class \code{"linnet"}).
  }
  \item{lambdacut}{
    Intensity of Poisson process of breakpoints.
  }
  \item{rintens}{
    Optional. Random variable generator
    used to generate the random intensity in each component.
  }
  \item{\dots}{
    Additional arguments to \code{rintens}.
  }
  \item{cuts}{
    String (partially matched) specifying the type of random cuts to be
    generated. 
  }
}
\details{
  This function generates simulated realisations of
  the Switzer-type point process on a network,
  as described in Baddeley et al (2017).

  The linear network is first divided into pieces by a random
  mechanism:
  \itemize{
    \item if \code{cuts="points"}, 
    a Poisson process of breakpoints with intensity \code{lambdacut}
    is generated on the network, and these breakpoints separate the
    network into connected pieces. 
    \item if \code{cuts="lines"}, a Poisson line process in the plane
    with intensity \code{lambdacut} is generated; these lines divide
    space into tiles; the network is divided into subsets associated
    with the tiles. Each subset may not be a connected sub-network.
  }
  In each piece of the network, a random intensity is generated
  using the random variable generator \code{rintens} (the default is
  a negative exponential random variable with rate 1). Given the
  intensity value, a Poisson process is generated with the specified
  intensity.

  The intensity of the final process is determined by the mean
  of the values generated by \code{rintens}. If \code{rintens=rexp} (the
  default), then the parameter \code{rate} specifies the inverse of the
  intensity. 
}
\value{
  Point pattern on a linear network (object of class \code{"lpp"})
  with an attribute \code{"breaks"} containing the breakpoints (if
  \code{cuts="points"}) or the random lines (if \code{cuts="lines"}).
}
\author{
  \adrian.
}
\seealso{
  \code{\link{rcelllpp}}
}
\references{
  Baddeley, A., Nair, G., Rakshit, S. and McSwiggan, G. (2017)
  \sQuote{Stationary} point processes are uncommon on
  linear networks. \emph{STAT} \bold{6}, {68--78}.
}
\examples{
   plot(rSwitzerlpp(domain(spiders), 0.01, rate=100))

   plot(rSwitzerlpp(domain(spiders), 0.0005, rate=100, cuts="l"))
}
\keyword{spatial}
\keyword{datagen}

\concept{Linear network}
