% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.annulus.R
\name{sample.annulus}
\alias{sample.annulus}
\title{Sample annulus}
\usage{
sample.annulus(x, r1, r2, n = 10, ...)
}
\arguments{
\item{x}{sp SpatialPoints or SpatialPointsDataFrame class object}

\item{r1}{Numeric value defining inner radius of annulus (in projection units)}

\item{r2}{Numeric value defining outer radius of annulus (in projection units)}

\item{n}{Number of samples}

\item{...}{Additional arguments passed to spsample}
}
\value{
sp SpatialPointsataFrame OBJECT
}
\description{
Creates sample points based on annulus with defined inner and outer radius
}
\note{
Function can be used for distance based sampling. This is one sampling method to capture the spatially lagged variation.
}
\examples{
library(sp)
library(rgeos)
data(meuse)
coordinates(meuse) <- ~x+y
proj4string(meuse) <- CRS("+init=epsg:28992")
xy <- meuse[2,]

rs100 <- sample.annulus(xy, r1=50, r2=100, n = 50, type = "random")
rs200 <- sample.annulus(xy, r1=100, r2=200, n = 50, type = "random")

plot(rs200, pch=20, col="red")
  points(rs100, pch=20, col="blue")
  points(xy, pch=20, cex=2, col="black")
  box()
  legend("topright", legend=c("50-100m", "100-200m", "source"), 
         pch=c(20,20,20), col=c("blue","red","black"))

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
