% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{subtract_rest_task}
\alias{subtract_rest_task}
\title{Subtract mean rest spectrum from mean task spectrum after applying optimal
linebroadening to the mean task spectrum. Usually used to correct for the
BOLD lineshape narrowing effect in 1H fMRS data.}
\usage{
subtract_rest_task(mrs_data, task_vec, xlim = c(2.11, 1.91))
}
\arguments{
\item{mrs_data}{dynamic MRS data.}

\item{task_vec}{a logical vector with the same length and dynamic scans.
Elements set to TRUE and FALSE will be assigned to task and rest
respectively.}

\item{xlim}{spectral region to match, eg c(2.11, 1.91) for tNAA region.}
}
\value{
a list containing the matched mrs_data, difference spectra and
optimisation results.
}
\description{
Subtract mean rest spectrum from mean task spectrum after applying optimal
linebroadening to the mean task spectrum. Usually used to correct for the
BOLD lineshape narrowing effect in 1H fMRS data.
}
