% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{scale_spec}
\alias{scale_spec}
\title{Scale mrs_data to a spectral region.}
\usage{
scale_spec(
  mrs_data,
  xlim = NULL,
  operator = "sum",
  freq_scale = "ppm",
  mode = "re",
  mean_dyns = NULL,
  ret_scale_factor = FALSE
)
}
\arguments{
\item{mrs_data}{MRS data.}

\item{xlim}{spectral range to be integrated (defaults to full range).}

\item{operator}{can be "sum" (default), "mean", "l2", "max", "min" or
"max-min".}

\item{freq_scale}{units of xlim, can be : "ppm", "Hz" or "points".}

\item{mode}{spectral mode, can be : "re", "im", "mod" or "cplx".}

\item{mean_dyns}{mean the dynamic scans before applying the operator. The
same scaling value will be applied to each individual dynamic.}

\item{ret_scale_factor}{option to return the scaling factor in addition to
the scaled data.}
}
\value{
normalised data.
}
\description{
Scale mrs_data to a spectral region.
}
