% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_values.R
\name{generate_halton_random_set}
\alias{generate_halton_random_set}
\title{Generate Halton Set (Randomly Initialized)}
\usage{
generate_halton_random_set(n, dim, seed = 0)
}
\arguments{
\item{n}{The number of values (per dimension) to extract.}

\item{dim}{The number of dimensions of the sequence.}

\item{seed}{Default `0`. The random seed.}
}
\value{
An `n` x `dim` matrix listing all the
}
\description{
Generate a set of values from a seeded Halton set.
}
\examples{
#Generate a 2D sample:
points2d = generate_halton_random_set(n=1000, dim=2)
plot(points2d)

#Change the seed and extract a separate pair of dimensions
points2d = generate_halton_random_set(n=1000, dim=10,seed=2)
plot(points2d[,5:6])

#Integrate the value of pi by counting the number of randomly generated points that fall
#within the unit circle.
pointset = matrix(generate_halton_random_set(10000,dim=2),ncol=2)

pi_estimate = 4*sum(pointset[,1] * pointset[,1] + pointset[,2] * pointset[,2] < 1)/10000
pi_estimate
}
