"spmap.to.lev" <- function (data, zcol = 1:n, n = 2, names.attr)
{
	if (!(is(data, "SpatialPointsDataFrame") || (is(data, "SpatialGridDataFrame"))))
		stop("data is not of a class that extends SpatialPointsDataFrame")

	if (dimensions(data) > 2) {
		warning("spmap.to.lev ignores spatial dimensions beyond the first 2")
		cc = coordinates(data)[,1:2]
		data = as(data, "data.frame")
		coordinates(data) = cc
	}
	coord.names = dimnames(data@coords)[[2]]

	data = stack(as(data, "SpatialPointsDataFrame"), zcol) # replace with data.frame
	if (!missing(names.attr)) {
		if (length(names.attr) != length(zcol))
			stop("length names.attr should match length of zcol")
		data$ind = factor(as.integer(data$ind), labels = names.attr)
	}
	names(data) = c(coord.names, "z", "name")
	data
}

stack.SpatialPointsDataFrame = function (x, select, ...)
{
	xd = x@data
   	cc = coordinates(x)
	cc.names = dimnames(cc)[[2]]

	if (!missing(select))
		xd = xd[select]
	nc = ncol(xd)
	xd = stack(data.frame(lapply(xd, as.numeric)))

	ccr = data.frame(rep(cc[,1], nc))
	for (i in 2:ncol(cc))
		ccr = data.frame(ccr, rep(cc[,i], nc))
	names(ccr) = cc.names
	data.frame(ccr, xd)
}

stack.SpatialGridDataFrame = function (x, select, ...)
	stack(as(x, "SpatialPointsDataFrame"), select, ...)

stack.SpatialPixelsDataFrame = function (x, select, ...)
	stack(as(x, "SpatialPointsDataFrame"), select, ...)
