% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{reportCI}
\alias{reportCI}
\title{Report CI}
\usage{
reportCI(n, digits = 2, suffix = NULL)
}
\arguments{
\item{n}{numeric vector or matrix}

\item{digits}{number of decimal points to preserve}
}
\description{
Internal soundgen function
}
\details{
Takes a numeric vector or matrix with three elements / columns: fit, lower
quantile from a CI, and upper quantile from a CI. For each row, it prints the
result as fit and CI in square brackets
}
\examples{
n = rnorm(100)
soundgen:::reportCI(quantile(n, probs = c(.5, .025, .975)))

a = data.frame(fit = c(3, 5, 7),
               lwr = c(1, 4, 6.5),
               upr = c(5, 6, 7.1))
soundgen:::reportCI(a, 1)
soundgen:::reportCI(a, 1, ' cm')
soundgen:::reportCI(a, 1, '\%, 95\% CI')
}
\keyword{internal}
