% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{matchLengths}
\alias{matchLengths}
\title{Resize vector to required length}
\usage{
matchLengths(
  myseq,
  len,
  padDir = c("left", "right", "central")[3],
  padWith = 0
)
}
\arguments{
\item{myseq}{input vector}

\item{len}{target length}

\item{padDir}{specifies the affected side. For padding, it is the side on
which new elements will be added. For trimming, this is the side that will
be trimmed. Defaults to 'central'}

\item{padWith}{if the vector needs to be padded to match the required length,
what should it be padded with? Defaults to 0}
}
\value{
Returns the modified vector of the required length.
}
\description{
Internal soundgen function.
}
\details{
Adjusts a vector to match the required length by either trimming one or both
ends or padding them with zeros.
}
\examples{
soundgen:::matchLengths(c(1, 2, 3), len = 5)
soundgen:::matchLengths(3:7, len = 3)
# trimmed on the left
soundgen:::matchLengths(3:7, len = 3, padDir = 'left')
# padded with zeros on the left
soundgen:::matchLengths(3:7, len = 10, padDir = 'left')
#' # trimmed on the right
soundgen:::matchLengths(3:7, len = 3, padDir = 'right')
# padded with zeros on the right
soundgen:::matchLengths(3:7, len = 10, padDir = 'right')
}
\keyword{internal}
