% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{interpolMatrix}
\alias{interpolMatrix}
\title{Interpolate matrix}
\usage{
interpolMatrix(m, nr = NULL, nc = NULL, interpol = c("approx", "spline")[1])
}
\arguments{
\item{m}{input matrix of numeric values}

\item{nr, nc}{target dimensions}

\item{interpol}{interpolation method ('approx' for linear, 'spline' for
spline)}
}
\description{
Internal soundgen function
}
\details{
Performs a chosen type of interpolation (linear or smooth) across both rows
and columns of a matrix, in effect up- or downsampling a matrix to required
dimensions. Rownames and colnames are also interpolated as needed.
}
\examples{
m = matrix(1:12 + rnorm(12, 0, .2), nrow = 3)
rownames(m) = 1:3; colnames(m) = 1:4
soundgen:::interpolMatrix(m)  # just returns the original
soundgen:::interpolMatrix(m, nr = 10, nc = 7)
soundgen:::interpolMatrix(m, nr = 10, nc = 7, interpol = 'spline')
soundgen:::interpolMatrix(m, nr = 2, nc = 7)
soundgen:::interpolMatrix(m, nr = 2, nc = 3)

# input matrices can have a single row/column
soundgen:::interpolMatrix(matrix(1:5, nrow = 1), nc = 9)
soundgen:::interpolMatrix(matrix(1:5, ncol = 1), nr = 5, nc = 3)
}
\keyword{internal}
