% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hillenbrand}
\alias{hillenbrand}
\title{Formants in American vowels}
\format{
An object of class \code{data.frame} with 12 rows and 3 columns.
}
\usage{
hillenbrand
}
\description{
Relative frequencies of F1 and F2 (semitones above or below schwa based on
estimated VTL) in American English, from Hillenbrand (1995), who measured
F1-F4 in ~1.5K recordings (139 speakers, 12 vowels from each). Audio and
formant measurements are freely available online:
https://homepages.wmich.edu/~hillenbr/voweldata.html. The dataset below is
the result of modeling Hillenbrand's data with brms: mvbind(F1rel, F2rel) ~
vowel. It shows the most credible location of each vowel centroid in the
F1Rel-F2Rel space.
}
\details{
A dataframe of 12 observations and 3 columns: "vowel" = vowel (American
English), "F1Rel" and "F2Rel" = formant frequencies in semitones relative to
their neutral, equidistant positions in a perfectly cylindrical vocal tract.
See \code{\link{schwa}} - this is what schwa() returns as
$ff_relative_semitones
}
\examples{
plot(hillenbrand$F1Rel, hillenbrand$F2Rel, type = 'n')
text(hillenbrand$F1Rel, hillenbrand$F2Rel, labels = hillenbrand$vowel)
}
\references{
Hillenbrand, J., Getty, L. A., Clark, M. J., & Wheeler, K.
  (1995). Acoustic characteristics of American English vowels. The Journal of
  the Acoustical society of America, 97(5), 3099-3111.
}
\keyword{datasets}
