% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{.addAM}
\alias{.addAM}
\title{Add AM to a sound}
\usage{
.addAM(
  audio,
  amDep = 25,
  amFreq = 30,
  amType = c("logistic", "sine")[1],
  amShape = 0,
  invalidArgAction = c("adjust", "abort", "ignore")[1],
  plot = FALSE,
  play = FALSE
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{amDep}{amplitude modulation (AM) depth, \%. 0: no change; 100: AM with
amplitude range equal to the dynamic range of the sound (anchor format)}

\item{amFreq}{AM frequency, Hz (anchor format)}

\item{amType}{"sine" = sinusoidal, "logistic" = logistic (default)}

\item{amShape}{ignore if amType = "sine", otherwise determines the shape of
non-sinusoidal AM: 0 = ~sine, -1 = notches, +1 = clicks (anchor format)}

\item{invalidArgAction}{what to do if an argument is invalid or outside the
range in \code{permittedValues}: 'adjust' = reset to default value, 'abort'
= stop execution, 'ignore' = throw a warning and continue (may crash)}

\item{plot}{if TRUE, plots the amplitude modulation}

\item{play}{if TRUE, plays the processed audio}
}
\description{
Internal soundgen function, see \code{\link{addAM}}.
}
\keyword{internal}
