% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{ERBToHz}
\alias{ERBToHz}
\title{Convert Hz to ERB rate}
\usage{
ERBToHz(e, method = c("linear", "quadratic")[1])
}
\arguments{
\item{e}{vector or matrix of frequencies in ERB rate}

\item{method}{approximation to use}
}
\description{
Converts from Hz to the number of Equivalent Rectangular Bandwidths (ERBs)
below input frequency. See https://www2.ling.su.se/staff/hartmut/bark.htm and
https://en.wikipedia.org/wiki/Equivalent_rectangular_bandwidth
}
\examples{
freqs_Hz = c(-20, 20, 100, 440, 1000, 20000, NA)
e_lin = HzToERB(freqs_Hz, 'linear')
ERBToHz(e_lin, 'linear')

e_quad = HzToERB(freqs_Hz, 'quadratic')
ERBToHz(e_quad, 'quadratic')
}
\seealso{
\code{\link{HzToERB}} \code{\link{HzToSemitones}}
  \code{\link{HzToNotes}}
}
