% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_loudness.R
\name{getLoudnessPerFrame}
\alias{getLoudnessPerFrame}
\title{Get loudness per frame}
\usage{
getLoudnessPerFrame(spec, samplingRate, spreadSpectrum = TRUE)
}
\arguments{
\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{spreadSpectrum}{if TRUE, applies a spreading function to account for
frequency masking}
}
\description{
Internal soundgen function
}
\details{
Takes as input the absolute (not power) spectrum of a single STFT frame and
estimates its loudness in sone. See \code{\link{getLoudness}} for details.
}
\examples{
sound = sin(2*pi*1000/16000*(1:1000))
sound_scaled = soundgen:::scaleSPL(sound, SPL_measured = 40)
spec = spectrogram(
  sound_scaled, samplingRate = 16000, windowLength = 10,
  normalize = FALSE, output = 'original')[, 10]
# plot(spec, type = 'l')
soundgen:::getLoudnessPerFrame(spec, samplingRate = 16000)  # 1 sone
}
\keyword{internal}
