% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{medianSmoother}
\alias{medianSmoother}
\title{Median smoothing}
\usage{
medianSmoother(df, smoothing_ww, smoothingThres)
}
\arguments{
\item{df}{dataframe (each column is processed separately, so multiple
contours can be fed into this function at once to speed things up)}

\item{smoothing_ww}{width of smoothing window (points)}

\item{smoothingThres}{tolerated deviance from moving median (semitones)}
}
\value{
Returns a dataframe of the same dimensions as df.
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for smoothing pitch contours or other contours. Only
outliers are modified, so it's not like smoothing with a kernel. NB: the
expected input is pitch, so deviance is calculated on a log-scale.
}
\examples{
df = data.frame(a = rnorm(100, mean = 100, sd = 20),
                b = rnorm(100, mean = 100, sd = 10))
df1 = soundgen:::medianSmoother(df, smoothing_ww = 5, smoothingThres = 1)
plot(df[, 2], type='b')
lines(df1[, 2], type='b', col='blue', pch=3)
}
\keyword{internal}
