print.summary.soptdmaeA<-function(x,...)
{
cat("\n        ---------------------------------------    \n")
cat("Title: Sequential ",x$Optcrit,"-optimal or near-optimal ",if(x$dtype=="rcd") {"row-column"} else{"block"} ," design        ","Date: ", format(Sys.time(), "%a %b %d %Y %H:%M:%S"),"\n",sep="")
cat("        ---------------------------------------    \n")
cat("Call:\n")
print(x$call)
cat("\nParametric combinations:\n")
cat("\nNumber of treatments:          ",  x$v, "\n")
cat("Number of arrays:              ", x$b, "\n")
cat("Theta value:                   ",  x$theta, "\n")
cat("Number of replications:        ",  x$nrep, "\n")
cat("Number of added treatments:    ",   x$strt, "\n")
cat("Number of added arrays:        ",   x$sary, "\n")
cat("Algorithm used:                ", "Array exchange", "\n")
cat("Optimality criterion used:      ", x$Optcrit, "-optimality criteria\n",sep="")
cat("\nInitial ",x$Optcrit,"-optimal or near-optimal ",if(x$dtype=="rcd") {"row-column"} else{"block"} ," design:\n",sep="")
cat("\n")
print(data.frame(x$optdes0))
cat("\n")
cat(x$Optcrit,"-Score value of inital design:  ", x$optcrtsv0, "\n",sep="")
cat("\nResultant sequential ",x$Optcrit,"-optimal or near-optimal ",if(x$dtype=="rcd") {"row-column"} else{"block"} ," design:\n",sep="")
cat("\n")
print(data.frame(x$soptdesF))
cat("\n")
cat(x$Optcrit,"-Score value:  ", x$soptcrtsv, "\n",sep="")
par(mfrow = c(1, 2)) 
plot(x$grphlt0,edge.arrow.size=0.6, vertex.size=20, margin=0,
    layout=layout.kamada.kawai,vertex.color="cyan",edge.color="black")
title(paste("Initial ",x$Optcrit, "-optimal or near-optimal ",if(x$dtype=="rcd") {"row-column"} else{"block"} ," design",sep=""), 
     sub = NULL,cex.main = 0.55,   font.main= 1, col.main= "black")
mtext(paste("(v, b, theta, ",x$Optcrit,"score) =", " (",paste((x$v-x$strt), (x$b-x$sary), x$theta, format(x$optcrtsv0,5,5,0), sep=", "),")",sep=""), line = 0.50, col = "blue", cex=0.7,font = 1)
plot(x$grphlt,edge.arrow.size=0.6, vertex.size=20, margin=0,
     layout=layout.kamada.kawai)
title(paste("Sequential ",x$Optcrit, "-optimal or near-optimal ",if(x$dtype=="rcd") {"row-column"} else{"block"} ," design",sep=""), 
      sub = NULL,cex.main = 0.55,   font.main= 1, col.main= "black")
mtext(paste("(v, b, theta, ",x$Optcrit,"score) =", " (",paste(x$v, x$b, x$theta, format(x$soptcrtsv,5,5,0), sep=", "),")",sep=""), line = 0.50, col = "blue",cex=0.7, font = 1)
cat("\n", x$file_loc2,"\n", x$file_loc,"\n")
cat("\n")
}
