#' Work with documents in your CouchDB's.
#'
#' @name documents
#' @details If you are writing a complicated javascript function, better to do
#' that in the Futon CouchDB interface or otherwise.
#'
#' There are the following functions for working with documents:
#' \itemize{
#'  \item \code{\link{doc_create}} - Create a document, with or without an ID
#'  \item \code{\link{doc_update}} - Update a document
#'  \item \code{\link{doc_get}} - Get a document
#'  \item \code{\link{doc_delete}} - Delete a document
#'  \item \code{\link{doc_head}} - Get headers for a document
#'  \item \code{\link{doc_attach_create}} - Attach something to a document
#'  \item \code{\link{doc_attach_info}} - Get info on an attachment
#'  \item \code{\link{doc_attach_get}} - Fetch an attachment
#'  \item \code{\link{doc_attach_delete}} - Delete an attachment
#'  \item \code{\link{db_alldocs}} - Get all documents
#'  \item \code{\link{db_revisions}} - Get revisions for a document
#' }
NULL
