%  file sn/man/plot.selm.Rd  
%  This file is a component of the package 'sn' for R
%  copyright (C) 2013 Adelchi Azzalini
%---------------------
\name{plot.selm}
\alias{plot.selm}
\alias{plot.mselm}
\alias{plot,selm-method}
\alias{plot,mselm-method}
\concept{QQ-plot}

\title{Diagnostic plots for \code{selm} fits}

\description{Diagnostic plots for objects of class \code{selm}
  and \code{mselm} generated by a call to function \code{selm}}

\usage{
  \S4method{plot}{selm}(x, param.type="CP", which = c(1:4), caption, 
    panel = if (add.smooth) panel.smooth else points, main = "", 
    ask = prod(par("mfcol")) < length(which) && dev.interactive(), ..., 
    id.n = 3, labels.id = names(x@residuals.dp), 
    cex.id = 0.75, identline = TRUE, add.smooth = getOption("add.smooth"), 
    label.pos = c(4, 2), cex.caption = 1) 

 \S4method{plot}{mselm}(x, param.type="CP",  which, caption, 
    panel = if (add.smooth) panel.smooth else points,  main = "", 
    ask = prod(par("mfcol")) < length(which) && dev.interactive(), ..., 
    id.n = 3, labels.id = names(x@residuals.dp), 
    cex.id = 0.75, identline = TRUE, add.smooth = getOption("add.smooth"), 
    label.pos = c(4, 2), cex.caption = 1)
}

\arguments{
  \item{x}{an object of class \code{selm} or \code{mselm}.}

  \item{param.type}{a character string which selects the type of residuals
    to be used for some of of the plots; 
    possible values are: \code{"CP"} (default), \code{"DP"}, 
    \code{"pseudo-CP"}. The various type of residuals only differ by an 
    additive term; see \sQuote{Details} for more information.}

  \item{which}{if a subset of the plots is required, specify a subset of 
    \code{1:4}; see \sQuote{Details} for a description of the plots.}

  \item{caption}{a vector of character strings with captions to appear above 
    the plots.}
 
  \item{panel}{panel function.  The useful alternative to \code{points},
          \code{panel.smooth} can be chosen by \code{add.smooth = TRUE}.}

  \item{main}{title to each plot, in addition to the above caption.}

  \item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

  \item{\dots}{other parameters to be passed through to plotting functions.}
    % see \sQuote{Details} for restrictions.}

  \item{id.n}{number of points to be labelled in each plot, starting with the
    most extreme.}

  \item{labels.id}{vector of labels, from which the labels for extreme points
    will be chosen. \code{NULL} uses observation numbers..}

  \item{cex.id}{magnification of point labels.}
 
  \item{identline}{logical indicating if an identity line should be added to
    QQ-plot and PP-plot (default: \code{TRUE}).}

  \item{add.smooth}{logical indicating if a smoother should be added to most 
    plots; see also \code{panel} above.}

  \item{label.pos}{ positioning of labels, for the left half and right 
     half of the graph respectively, for plots 1-3.}

  \item{cex.caption}{controls the size of \code{caption}.}
}

\details{ The meaning of \code{param.type} is described in
\code{\link{dp2cp}}. However, for these plot only the first parameter
component is relevant, which affects the location of the residuals; the other
components are not computed. Moreover, for \acronym{QQ}-plot and
\acronym{PP}-plot, \acronym{DP}-residuals are used irrespectively of
\code{param.type}; see Section \sQuote{Background}.

% Graphical parameters can be specified via \code{\dots}, but not those 
% specified by the function: \code{xlab}, \code{ylab}, \code{cex}.

Values \code{which=1} and \code{which=2} have a
different effect for object of class \code{"selm"} and class \code{"mselm"}.
In the univariate case, \code{which=1} plots the residual values versus the
fitted values if \code{p>1}, where \code{p} denotes the number of covariates
including the constant; if \code{p=1}, a boxplot of the response is produced.
Value \code{which=2} produces an histogram of the residuals with superimposed
the fitted curve, when \code{p>1}; if \code{p=1}, a similar plot is generated
using the response variable instead of the residuals. Default value for
\code{which} is \code{1:4}.

In the multivariate case, \code{which=1} is feasible only if \code{p=1} and it
displays the data scatter with superimposed the fitted distribution. Value
\code{which=2} produces a similar plot but for residuals instead of
data. Default value for code{which} is \code{2:4} if \code{p>1}, otherwise
\code{c(1,3,4)}. 

Value \code{which=3} produces a QQ-plot, both in the univariate and in the
multivariate case; the difference is that the squares of normalized residuals
and suitably defined Mahalanobis distances, respectively, are used in the two
cases. Similarly, \code{which=4} produces a PP-plot, working in a similar
fashion.}

\section{Background}{
Healy-type graphical diagnostics, in the form of QQ- and PP-plots, for the 
multivariate normal distribution have been extended to the skew-normal
distribution by Azzalini and Capitanio (1999, section 6.1), and subsequently 
to the skew-\eqn{t} distribution in Azzalini and Capitanio (2003). 
A brief explanation in the univariate \acronym{SN} case is provided 
in Section 3.1.1 of Azzalini and Capitanio (2014); see also Section 3.1.6.
For the univariate \acronym{ST} case, see p.102 and p.111 of the monograph.
The multivariate case is discussed in Section 5.2.1 as for the \acronym{SN}
distribution, in Section 6.2.6 as for the \acronym{ST} distribution.
}    


\references{
  Azzalini, A. and Capitanio, A. (1999).
  Statistical applications of the multivariate skew normal distribution.
  \emph{J.Roy.Statist.Soc. B} \bold{61}, 579-602. 
  Full-length version available at \url{https://arXiv.org/abs/0911.2093}

  Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry with emphasis on
  a multivariate skew \emph{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367-389.
  Full-length version available at \url{https://arXiv.org/abs/0911.2342}

  Azzalini, A. with the collaboration of Capitanio, A. (2014). 
  \emph{The Skew-Normal and Related Families}. 
  Cambridge University Press, IMS Monographs series.
}

\seealso{\code{\link{selm}}, \code{\link{dp2cp}}}

\examples{
data(wines)
#
m10 <- selm(flavanoids  ~ 1, family="SN", data=wines, subset=(wine=="Barolo"))
plot(m10)
plot(m10, which=c(1,3)) # fig 3.1 and 3.2(a) of Azzalini and Capitanio (2014)
#
m18 <- selm(acidity ~ sugar + nonflavanoids + wine, family="SN", data=wines)
plot(m18)
plot(m18, param.type="DP")
#
m28 <- selm(cbind(acidity, alcohol) ~ sugar + nonflavanoids + wine, 
            family="SN", data=wines)
plot(m28, col=4)            
# 
data(ais)
m30 <-  selm(cbind(RCC, Hg, Fe) ~ 1, family="SN", data=ais)
plot(m30, col=2, which=2)
}

\author{Adelchi Azzalini}

\keyword{hplot}
