% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbow_point.R
\name{elbow_point}
\alias{elbow_point}
\title{Compute Elbow Point}
\usage{
elbow_point(x, y)
}
\arguments{
\item{x}{A numeric vector}

\item{y}{A numeric vector}
}
\value{
A list with the index (\code{idx}), x-value (\code{x}) and
y-value (\code{y}) of the elbow point.
}
\description{
\code{elbow_point} computes the elbow point based on the maximum distance
between each point and the line passing through the end points.
}
\examples{
# generate some data
x <- c(0, 0.5, 1)
y <- c(1, 0.1, 0)
# plot data (the second point is clearly the elbow)
plot(x, y)
elbow_point(x, y)
}
\references{
\url{https://en.wikipedia.org/wiki/Distance_from_a_point_to_a_line}
}
\seealso{
\code{\link{optimal_ubpop}}
}
\author{
Joshua French and Mohammad Meysami
}
