% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.clusters.R
\name{color.clusters}
\alias{color.clusters}
\title{Color clusters}
\usage{
color.clusters(
  x,
  idx = seq_along(x$clusters),
  col = grDevices::hcl.colors(length(idx))
)
}
\arguments{
\item{x}{An object of class scan produced by a function
such as \code{scan.test}.}

\item{idx}{An index vector indicating the elements of
\code{object$clusters} to print information for. The default
is all clusters.}

\item{col}{A vector of colors to color the clusters in
\code{x}.  Should have same length as the number of
clusters in \code{x}.}
}
\value{
Returns a vector with colors for each
  region/centroid for the data set used to construct
  \code{x}.
}
\description{
\code{color.clusters} is a helper function to color
clusters of regions produced by an appropriate method,
e.g., \code{scan.test} or \code{uls.test}.  Regions that
are not part of any cluster have no color.
}
\examples{
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
out = scan.test(coords = coords, cases = floor(nydf$cases),
                pop = nydf$pop, alpha = 0.2, longlat = TRUE,
                nsim = 9)
data(nypoly)
library(sp)
# plot all clusters
plot(nypoly, col = color.clusters(out), axes = TRUE)
# zoom in on small cluster
plot(nypoly, col = color.clusters(out),
     xlim = c(400000, 450000),
     ylim = c(4750000, 4800000))
# plot only clusters 1 and 3
plot(nypoly, col = color.clusters(out, idx = c(1, 3)))
}
\author{
Joshua French
}
