% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg.R
\name{csg}
\alias{csg}
\alias{lcsg}
\alias{scsg}
\title{Construct connected subgraphs}
\usage{
csg(set, idx, w)

lcsg(lset, idx, w)

scsg(idx, w, verbose = FALSE)
}
\arguments{
\item{set}{A vector of (presumably connected) vertices.}

\item{idx}{A vector of vertices considered for inclusion in the
subgraph, e.g., based on nearest neighbors.}

\item{w}{The adjacency matrix for all vertices by row, but with only the \code{idx} columns}

\item{lset}{A list of sets.}

\item{verbose}{A logical value indicating whether very descriptive messages
should be provided.  Default is \code{FALSE}.  If \code{TRUE}, this can
be useful for diagnosing where the sequences of connected subgraphs is
slowing down/having problems.}
}
\value{
A list of with all possible combinations of \code{set} and
each possible connected vertex in \code{idx}, or \code{NULL} if none
are possible.
}
\description{
\code{csg}, \code{lcsg}, and \code{scsg} construct
connected subgraphs.
\code{set} contains a vector of vertices of the pattern 1, 2, 3, ..., N.
\code{idx} is a vector of possible vertices being considered as a subgraph.
\code{w} is a connectivity matrix relating the N vertices.
\code{w[i,j] = 1} if vertices i and j are connected, i.e., if they share an edge.
The dimensions of \code{w} are \eqn{N times k}, where \code{k = length(idx)}.
While the rows of \code{w} contain adjacency information for all N
vertices, only the \code{idx} columns of the complete adjacency matrix
are used in \code{w}.  See Details for discussion of \code{scsg}.
}
\details{
\code{scsg} performs
a sequence of \code{lcsg} calls.  Starting with \code{lset == list(idx[1])},
\code{scsg} keeps iteratively building more connected subsgraphs by perfoming
something like:  set1 = list(idx[1]).  set2 = lcsg(set1, idx, w).
set3 = lcsg(set2, idx, w).  This is done until there are no more connected
subgraphs among the elements of \code{idx}.
}
\examples{
data(nydf)
data(nyw)
# determine 50 nn of region 1 for NY data
coords = as.matrix(nydf[,c("longitude", "latitude")])
d = sp::spDists(coords, longlat = TRUE)
nn50 = order(d[1,])[1:50]
w = nyw[,nn50]
set = 1
# first set of connected neighbors
nb1 = csg(set, idx = nn50, w = w)
# extend set of connected neighbors
# for first element of nb1
set2 = nb1[[1]]
nb2 = csg(set2, idx = nn50, w = w)
# do the same thing for all sets in nb1
nb2e = lcsg(nb1, idx = nn50, w = w)
# the sets in nb2 should be present in the
# first 9 positions of nb2e
all.equal(nb2, nb2e[seq_along(nb2)])

# apply scsg to first 10 nn of vertex 1
nn10 = order(d[1,])[1:10]
w = nyw[, nn10]
nb3 = scsg(nn10, w, verbose = TRUE)
}
