% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{body.position}
\alias{body.position}
\title{Computes position of Solar System bodies in equatorial coordinates}
\usage{
body.position(
  obj = "sun",
  time,
  timezone,
  calendar,
  dec,
  loc = NULL,
  refraction,
  atm,
  temp,
  verbose = T
)
}
\arguments{
\item{obj}{(Optional) String containing name of the solar system body of interest. Can be
any of the planets (inc. Pluto), the Moon, the Sun or the Ecliptic. Defaults to 'sun'.}

\item{time}{Either a string containing the date and time in the format "YYYY/MM/DD HH:MM:SS"
(see \code{\link{timestring}}), or a numeric containing the julian date (see \code{\link{time2jd}}).}

\item{timezone}{(Optional) Timezone of input either as a known acronym (e.g. "GMT", "CET") or
a string with continent followed by country capital (e.g. "Europe/London"). See
\link{timezones} for details. Only needed if \emph{time} is a string. #' If not given the value set
by \code{\link{skyscapeR.vars}} will be used instead.}

\item{calendar}{(Optional) Calendar used in parameter \emph{time}. G for gregorian and J for julian.
Only needed if \emph{time} is a string. If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{dec}{(Optional) Output declination: \emph{geo} for the geocentric, or \emph{topo} for the topocentric
frame of reference. If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{loc}{(Optional) Location, only needed if output is in topocentric declination.}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{verbose}{(Optional) Boolean to control whether or not to display text. Default is TRUE.}
}
\description{
This function calculates the geocentric or topocentric declination and right ascension of solar
 system bodies at a given time. It is a wrapper for function
 \code{\link[swephR]{swe_calc_ut}} of package \emph{swephR}.
}
\examples{
# Position of the sun at noon GMT on Christmas day 2018:
body.position('sun', '2018/12/25 12:00:00', timezone='GMT')

# Declination of the moon at same time
body.position('moon', '2018/12/25 12:00:00', timezone='GMT')$equatorial$Dec
}
\seealso{
\code{\link[swephR]{swe_calc_ut}}, \code{\link{timestring}}, \code{\link{time2jd}}
}
