% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{az2dec}
\alias{az2dec}
\title{Calculates declination from azimuth and altitude measurements}
\usage{
az2dec(
  az,
  loc,
  alt,
  refraction = skyscapeR.env$refraction,
  atm = skyscapeR.env$atm,
  temp = skyscapeR.env$temp
)
}
\arguments{
\item{az}{Azimuth(s) for which to calculate declination(s). See examples below.}

\item{loc}{Location, can be either a \emph{skyscapeR.horizon} object or, alternatively,
an array of latitude values.}

\item{alt}{(Optional) Altitude of orientation. If left empty and a \emph{skyscapeR.horizon}
is provided then this is will automatically retrieved from the horizon data via \code{\link{hor2alt}}}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}
}
\description{
This function calculates the declination corresponding to an
orientation , i.e. an azimuth. The altitude can either be given
 or, alternatively, if a \emph{skyscapeR.horizon} object is provided,
 the corresponding horizon altitude will be automatically retrieved.
This function is a wrapper for function \code{\link[swephR]{swe_azalt_rev}}
of package \emph{swephR}.
}
\examples{
dec <- az2dec(az=92, loc=c(35,-8), alt=2)

# flat horizon with 2 degrees of altitude
hor <- createHor(az=c(0,360), alt=c(2,2), loc=c(35,-8,25))
dec <- az2dec(92, loc=hor)

# Can also be used for an array of azimuths:
decs <- az2dec(az=c(87,92,110), loc=hor)
}
\seealso{
\code{\link[swephR]{swe_azalt_rev}}, \code{\link{hor2alt}}
}
